/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.coap.server.templates;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ResourceTemplate
implements IFileTemplate<InformationModel> {
    private String targetPath;
    private String classPackage;
    private String imports;

    public ResourceTemplate(String targetPath, String classPackage, String imports) {
        this.targetPath = targetPath;
        this.classPackage = classPackage;
        this.imports = imports;
    }

    public String getFileName(InformationModel context) {
        return "Resource.java";
    }

    public String getPath(InformationModel context) {
        return this.targetPath;
    }

    public String getContent(InformationModel context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)this.classPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.CoapResource;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.coap.CoAP;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.coap.LinkFormat;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.network.Exchange;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.server.resources.CoapExchange;");
        _builder.newLine();
        _builder.append((Object)"import ");
        _builder.append((Object)this.imports, "");
        _builder.append((Object)".*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.Collection;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import static org.eclipse.californium.core.coap.CoAP.ResponseCode.INTERNAL_SERVER_ERROR;");
        _builder.newLine();
        _builder.append((Object)"import static org.eclipse.californium.core.coap.CoAP.ResponseCode.METHOD_NOT_ALLOWED;");
        _builder.newLine();
        _builder.append((Object)"import static org.eclipse.californium.core.coap.CoAP.Type.NON;");
        _builder.newLine();
        _builder.append((Object)"import static org.eclipse.californium.core.coap.MediaTypeRegistry.APPLICATION_LINK_FORMAT;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class Resource extends CoapResource {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private ICoAPRequestHandler handler;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private Configuration config;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public Resource(String name, Configuration config, ICoAPRequestHandler handler) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"super(name);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"this.config = config;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"this.handler = handler;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if (config.isObserve()) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"setObservable(true);");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"setObserveType(NON);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public void handleRequest(Exchange exchange) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"final CoapExchange coapExchange = new CoapExchange(exchange, this);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"CoAP.Code code = exchange.getRequest().getCode();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"switch (code) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case GET:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"if (config.isGet() || config.isObserve()) {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"forwardRequest(coapExchange);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"} else if (config.isDiscover()) {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"discover(coapExchange);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"coapExchange.respond(METHOD_NOT_ALLOWED);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case POST:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"if (config.isPost()) {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"forwardRequest(coapExchange);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"coapExchange.respond(METHOD_NOT_ALLOWED);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case PUT:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"if (config.isPut()) {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"forwardRequest(coapExchange);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"coapExchange.respond(METHOD_NOT_ALLOWED);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case DELETE:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"if (config.isDelete()) {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"forwardRequest(coapExchange);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"coapExchange.respond(METHOD_NOT_ALLOWED);");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private void forwardRequest(CoapExchange exchange) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"handler.onRequest(exchange, this.getURI());");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"LOGGER.severe(this.getClass().getName() + \": \" + this.getName() + \" Caused exception: \" + e.toString());");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"exchange.respond(INTERNAL_SERVER_ERROR);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private void discover(CoapExchange exchange) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"final Collection<org.eclipse.californium.core.server.resources.Resource> children = this.getChildren();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"StringBuilder sb = new StringBuilder();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"for (org.eclipse.californium.core.server.resources.Resource child : children) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"sb.append(LinkFormat.serializeResource(child));");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"exchange.respond(CoAP.ResponseCode.CONTENT, sb.toString(), APPLICATION_LINK_FORMAT);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Configuration specifies which aspects of the SOME/IP Field are allowed (Get, Set, Event)");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static class Configuration {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"private boolean get;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"private boolean put;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"private boolean post;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"private boolean delete;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"private boolean discover;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"private boolean observe;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"public Configuration(boolean get, boolean put, boolean post, boolean delete, boolean discover, boolean");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"observe) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"this.get = get;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"this.put = put;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"this.post = post;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"this.delete = delete;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"this.discover = discover;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"this.observe = observe;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"public boolean isGet() {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return get;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"public boolean isPut() {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return put;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"public boolean isPost() {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return post;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"public boolean isDelete() {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return delete;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"public boolean isDiscover() {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return discover;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"public boolean isObserve() {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return observe;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

