/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.webui.tasks.templates;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ReadmeTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        return "README.md";
    }

    public String getPath(InformationModel context) {
        return "webdevice.example";
    }

    public String getContent(InformationModel context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"# Getting Started");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"The Web Device Generator automatically generates AngularJS binding code to UI elements, specific for functionblocks. It also schedules a Timer task to simulate events passed to the Web Sockets of your app. Feel free to create Dummy instance data in the Application.java file.");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"## Consume MQTT events in the web application");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"The web device application can easily be \"glued\" together with MQTT event subscriptions for a device. All you need to do is follow the next 5 steps:");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"### 1. Invoke Vorto MQTT Generator ");
        _builder.newLine();
        _builder.append((Object)"### 2. Add the generated MQTT Client Bundle in the pom.xml");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<dependency>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<groupId>mqtt.example</groupId>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<artifactId>mqtt.example.client</artifactId>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<version>1.0.0-SNAPSHOT</version>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"</dependency>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"### 3. Add MQTT specific server and topic configuration to the application.yml");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"For detailed information about the key of the topic, take a look at the generated MQTT Configuration for the specific functionblock.");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"Example configuration for a functionblock 'LightSensor':");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"mqtt:");
        _builder.newLine();
        _builder.append((Object)"  \t  ");
        _builder.append((Object)"connectionUrl: tcp://localhost:1883");
        _builder.newLine();
        _builder.append((Object)"  \t");
        _builder.append((Object)"topic:");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"lightsensor: mytopic");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"### 4. Reference the MQTT Configuration from your Spring Boot Application");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"Find the Spring Boot Application main class (Application.java) and add the Spring Boot Configuration class, LightSensor in this example:");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Import(MqttConfigurationLightSensor.class)");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public class Application extends SpringBootServletInitializer {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"...");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"### 5. Uncomment the ClientHandler Subscription to the MQTT event in the Application.java");
        _builder.newLine();
        return _builder.toString();
    }
}

