/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.options;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.StringObjectTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXmlEnumValue;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Logging;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Options;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.SchemaGeneration;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.TargetNoSqlDatabase;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.TargetServer;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.options.EclipseLinkLoggingComposite;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.options.PersistenceXmlSchemaGenerationComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkPersistenceUnitOptionsEditorPage
extends Pane<PersistenceUnit> {
    private PropertyValueModel<Options> optionsHolder;

    public EclipseLinkPersistenceUnitOptionsEditorPage(PropertyValueModel<PersistenceUnit> persistenceUnitModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(persistenceUnitModel, parentComposite, widgetFactory, resourceManager);
    }

    protected Composite addComposite(Composite parent) {
        return this.addSubPane(parent, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        Section sessionOptionsSection = this.getWidgetFactory().createSection(container, 256);
        sessionOptionsSection.setText(EclipseLinkUiMessages.PersistenceXmlOptionsTab_sessionSectionTitle);
        Control sessionOptionsComposite = this.initializeSessionOptionsSection(sessionOptionsSection);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        sessionOptionsSection.setLayoutData((Object)gridData);
        sessionOptionsSection.setClient(sessionOptionsComposite);
        Section schemaGenerationSection = this.getWidgetFactory().createSection(container, 256);
        schemaGenerationSection.setText(EclipseLinkUiMessages.PersistenceXmlSchemaGenerationTab_sectionTitle);
        gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        schemaGenerationSection.setLayoutData((Object)gridData);
        Control schemaGenerationComposite = this.initializeSchemaGenerationSection(schemaGenerationSection);
        schemaGenerationSection.setClient(schemaGenerationComposite);
        Section loggingSection = this.getWidgetFactory().createSection(container, 256);
        loggingSection.setText(EclipseLinkUiMessages.PersistenceXmlLoggingTab_sectionTitle);
        gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        loggingSection.setLayoutData((Object)gridData);
        Control loggingComposite = this.initializeLoggingSection(loggingSection);
        loggingSection.setClient(loggingComposite);
        Section miscellaneousSection = this.getWidgetFactory().createSection(container, 256);
        miscellaneousSection.setText(EclipseLinkUiMessages.PersistenceXmlOptionsTab_miscellaneousSectionTitle);
        gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        miscellaneousSection.setLayoutData((Object)gridData);
        Control miscellaneousComposite = this.initializeMiscellaneousSection(miscellaneousSection);
        miscellaneousSection.setClient(miscellaneousComposite);
    }

    private Control initializeSessionOptionsSection(Section section) {
        this.optionsHolder = this.buildOptionsHolder();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        Composite container = this.addPane((Composite)section, (Layout)layout);
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlOptionsTab_sessionName);
        Combo sessionNameCombo = this.addEditableCombo(container, this.buildDefaultSessionNameListHolder(), this.buildSessionNameHolder(), StringObjectTransformer.instance(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS_SESSION_NAME);
        SWTUtil.attachDefaultValueHandler((Combo)sessionNameCombo);
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlOptionsTab_sessionsXml);
        Combo sessionsXmlCombo = this.addEditableCombo(container, this.buildDefaultSessionsXmlFileNameListHolder(), this.buildSessionsXmlFileNameHolder(), StringObjectTransformer.instance(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS_SESSIONS_XML);
        SWTUtil.attachDefaultValueHandler((Combo)sessionsXmlCombo);
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlOptionsTab_targetDatabaseLabel);
        Combo targetDatabaseCombo = this.addEditableCombo(container, this.buildTargetDatabaseListHolder(), this.buildTargetDatabaseHolder(), this.buildTargetDatabaseConverter(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS_TARGET_DATABASE);
        SWTUtil.attachDefaultValueHandler((Combo)targetDatabaseCombo);
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlOptionsTab_targetServerLabel);
        Combo targetServerCombo = this.addEditableCombo(container, this.buildTargetServerListHolder(), this.buildTargetServerHolder(), this.buildTargetServerConverter(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS_TARGET_SERVER);
        SWTUtil.attachDefaultValueHandler((Combo)targetServerCombo);
        Hyperlink eventListenerLink = this.addHyperlink(container, EclipseLinkUiMessages.PersistenceXmlOptionsTab_eventListenerLabel);
        this.initializeEventListenerClassChooser(container, eventListenerLink);
        TriStateCheckBox includeDescriptorQueriesCheckBox = this.addTriStateCheckBoxWithDefault(container, EclipseLinkUiMessages.PersistenceXmlOptionsTab_includeDescriptorQueriesLabel, this.buildIncludeDescriptorQueriesHolder(), this.buildIncludeDescriptorQueriesStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        includeDescriptorQueriesCheckBox.getCheckBox().setLayoutData((Object)gridData);
        return container;
    }

    protected Control initializeLoggingSection(Section section) {
        return new EclipseLinkLoggingComposite<Logging>(this, this.buildLoggingHolder(), (Composite)section).getControl();
    }

    protected Control initializeSchemaGenerationSection(Section section) {
        return new PersistenceXmlSchemaGenerationComposite(this, this.buildSchemaGenerationHolder(), (Composite)section).getControl();
    }

    protected Control initializeMiscellaneousSection(Section section) {
        Composite container = this.addSubPane((Composite)section);
        this.addTriStateCheckBoxWithDefault(container, EclipseLinkUiMessages.PersistenceXmlOptionsTab_temporalMutableLabel, this.buildTemporalMutableHolder(), this.buildTemporalMutableStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_OPTIONS);
        return container;
    }

    private PropertyValueModel<SchemaGeneration> buildSchemaGenerationHolder() {
        return new TransformationPropertyValueModel<PersistenceUnit, SchemaGeneration>(this.getSubjectHolder()){

            protected SchemaGeneration transform_(PersistenceUnit value) {
                return ((EclipseLinkPersistenceUnit)value).getSchemaGeneration();
            }
        };
    }

    private PropertyValueModel<Logging> buildLoggingHolder() {
        return new TransformationPropertyValueModel<PersistenceUnit, Logging>(this.getSubjectHolder()){

            protected Logging transform_(PersistenceUnit value) {
                return ((EclipseLinkPersistenceUnit)value).getLogging();
            }
        };
    }

    private PropertyValueModel<Options> buildOptionsHolder() {
        return new TransformationPropertyValueModel<PersistenceUnit, Options>(this.getSubjectHolder()){

            protected Options transform_(PersistenceUnit value) {
                return ((EclipseLinkPersistenceUnit)value).getOptions();
            }
        };
    }

    private PropertyValueModel<String> buildDefaultSessionNameHolder() {
        return new PropertyAspectAdapter<Options, String>(this.optionsHolder, new String[]{""}){

            protected String buildValue_() {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionNameDefaultValue((Options)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultSessionNameListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultSessionNameHolder());
    }

    private ModifiablePropertyValueModel<String> buildSessionNameHolder() {
        return new PropertyAspectAdapter<Options, String>(this.optionsHolder, new String[]{"sessionName"}){

            protected String buildValue_() {
                String name = ((Options)this.subject).getSessionName();
                if (name == null) {
                    name = EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionNameDefaultValue((Options)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionNameDefaultValue((Options)this.subject).equals(value)) {
                    value = null;
                }
                ((Options)this.subject).setSessionName(value);
            }
        };
    }

    private String getSessionNameDefaultValue(Options subject) {
        String defaultValue = subject.getDefaultSessionName();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    private PropertyValueModel<String> buildDefaultSessionsXmlFileNameHolder() {
        return new PropertyAspectAdapter<Options, String>(this.optionsHolder, new String[]{""}){

            protected String buildValue_() {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionsXmlDefaultValue((Options)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultSessionsXmlFileNameListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultSessionsXmlFileNameHolder());
    }

    private ModifiablePropertyValueModel<String> buildSessionsXmlFileNameHolder() {
        return new PropertyAspectAdapter<Options, String>(this.optionsHolder, new String[]{"sessionsXml"}){

            protected String buildValue_() {
                String name = ((Options)this.subject).getSessionsXml();
                if (name == null) {
                    name = EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionsXmlDefaultValue((Options)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkPersistenceUnitOptionsEditorPage.this.getSessionsXmlDefaultValue((Options)this.subject).equals(value)) {
                    value = null;
                }
                ((Options)this.subject).setSessionsXml(value);
            }
        };
    }

    private String getSessionsXmlDefaultValue(Options subject) {
        String defaultValue = subject.getDefaultSessionsXml();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    private PropertyValueModel<String> buildDefaultTargetDatabaseHolder() {
        return new PropertyAspectAdapter<Options, String>(this.optionsHolder, new String[]{Options.DEFAULT_TARGET_DATABASE}){

            protected String buildValue_() {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetDatabaseDefaultValue((Options)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultTargetDatabaseListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultTargetDatabaseHolder());
    }

    private String buildTargetDatabaseDisplayString(String targetDatabaseName) {
        switch (TargetNoSqlDatabase.valueOf((String)targetDatabaseName)) {
            case mongodb: {
                return EclipseLinkUiMessages.TargetDatabaseComposite_mongodb;
            }
        }
        throw new IllegalStateException();
    }

    private Comparator<String> buildTargetDatabaseComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String value1, String value2) {
                value1 = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetDatabaseDisplayString(value1);
                value2 = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetDatabaseDisplayString(value2);
                return Collator.getInstance().compare(value1, value2);
            }
        };
    }

    private Transformer<String, String> buildTargetDatabaseConverter() {
        return new TransformerAdapter<String, String>(){

            public String transform(String value) {
                try {
                    TargetNoSqlDatabase.valueOf((String)value);
                    value = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetDatabaseDisplayString(value);
                }
                catch (Exception exception) {}
                return value;
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildTargetDatabaseHolder() {
        return new PropertyAspectAdapter<Options, String>(this.optionsHolder, new String[]{"targetDatabase"}){

            protected String buildValue_() {
                String name = ((Options)this.subject).getTargetDatabase();
                if (name == null) {
                    name = EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetDatabaseDefaultValue((Options)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetDatabaseDefaultValue((Options)this.subject).equals(value)) {
                    value = null;
                }
                ((Options)this.subject).setTargetDatabase(value);
            }
        };
    }

    private ListValueModel<String> buildTargetDatabaseListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultTargetDatabaseListHolder());
        holders.add(this.buildTargetDatabasesListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private Iterator<String> buildTargetDatabases() {
        return TargetNoSqlDatabase.getTargetNoSqlDatabaseAdapterNames();
    }

    private CollectionValueModel<String> buildTargetDatabasesCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildTargetDatabases()));
    }

    private ListValueModel<String> buildTargetDatabasesListHolder() {
        return new SortedListValueModelAdapter(this.buildTargetDatabasesCollectionHolder(), this.buildTargetDatabaseComparator());
    }

    private String getTargetDatabaseDefaultValue(Options subject) {
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    private PropertyValueModel<String> buildDefaultTargetServerHolder() {
        return new PropertyAspectAdapter<Options, String>(this.optionsHolder, new String[]{Options.DEFAULT_TARGET_SERVER}){

            protected String buildValue_() {
                return EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetServerDefaultValue((Options)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultTargetServerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultTargetServerHolder());
    }

    private String buildTargetServerDisplayString(String targetServerName) {
        switch (TargetServer.valueOf((String)targetServerName)) {
            case jboss: {
                return EclipseLinkUiMessages.TargetServerComposite_jboss;
            }
            case netweaver_7_1: {
                return EclipseLinkUiMessages.TargetServerComposite_netweaver_7_1;
            }
            case none: {
                return EclipseLinkUiMessages.TargetServerComposite_none;
            }
            case oc4j: {
                return EclipseLinkUiMessages.TargetServerComposite_oc4j;
            }
            case sunas9: {
                return EclipseLinkUiMessages.TargetServerComposite_sunas9;
            }
            case weblogic: {
                return EclipseLinkUiMessages.TargetServerComposite_weblogic;
            }
            case weblogic_10: {
                return EclipseLinkUiMessages.TargetServerComposite_weblogic_10;
            }
            case weblogic_9: {
                return EclipseLinkUiMessages.TargetServerComposite_weblogic_9;
            }
            case websphere: {
                return EclipseLinkUiMessages.TargetServerComposite_websphere;
            }
            case websphere_6_1: {
                return EclipseLinkUiMessages.TargetServerComposite_websphere_6_1;
            }
            case websphere_7: {
                return EclipseLinkUiMessages.TargetServerComposite_websphere_7;
            }
        }
        throw new IllegalStateException();
    }

    private Comparator<String> buildTargetServerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String targetServer1, String targetServer2) {
                targetServer1 = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetServerDisplayString(targetServer1);
                targetServer2 = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetServerDisplayString(targetServer2);
                return Collator.getInstance().compare(targetServer1, targetServer2);
            }
        };
    }

    private Transformer<String, String> buildTargetServerConverter() {
        return new TransformerAdapter<String, String>(){

            public String transform(String value) {
                try {
                    TargetServer.valueOf((String)value);
                    value = EclipseLinkPersistenceUnitOptionsEditorPage.this.buildTargetServerDisplayString(value);
                }
                catch (Exception exception) {}
                return value;
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildTargetServerHolder() {
        return new PropertyAspectAdapter<Options, String>(this.optionsHolder, new String[]{"targetServer"}){

            protected String buildValue_() {
                String name = ((Options)this.subject).getTargetServer();
                if (name == null) {
                    name = EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetServerDefaultValue((Options)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkPersistenceUnitOptionsEditorPage.this.getTargetServerDefaultValue((Options)this.subject).equals(value)) {
                    value = null;
                }
                ((Options)this.subject).setTargetServer(value);
            }
        };
    }

    private ListValueModel<String> buildTargetServerListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultTargetServerListHolder());
        holders.add(this.buildTargetServersListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private Iterator<String> buildTargetServers() {
        return IteratorTools.transform((Iterator)IteratorTools.iterator((Object[])TargetServer.values()), (Transformer)PersistenceXmlEnumValue.ENUM_NAME_TRANSFORMER);
    }

    private CollectionValueModel<String> buildTargetServersCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildTargetServers()));
    }

    private ListValueModel<String> buildTargetServersListHolder() {
        return new SortedListValueModelAdapter(this.buildTargetServersCollectionHolder(), this.buildTargetServerComparator());
    }

    private String getTargetServerDefaultValue(Options subject) {
        String defaultValue = subject.getDefaultTargetServer();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    private ClassChooserPane<Options> initializeEventListenerClassChooser(Composite container, Hyperlink hyperlink) {
        return new ClassChooserPane<Options>((Pane)this, this.optionsHolder, container, hyperlink){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<Options, String>(this.getSubjectHolder(), new String[]{"eventListener"}){

                    protected String buildValue_() {
                        return ((Options)this.subject).getEventListener();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((Options)this.subject).setEventListener(value);
                    }
                };
            }

            protected String getClassName() {
                return ((Options)this.getSubject()).getEventListener();
            }

            protected IJavaProject getJavaProject() {
                return ((Options)this.getSubject()).getJpaProject().getJavaProject();
            }

            protected void setClassName(String className) {
                ((Options)this.getSubject()).setEventListener(className);
            }

            protected String getSuperInterfaceName() {
                return "org.eclipse.persistence.sessions.SessionEventListener";
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildIncludeDescriptorQueriesHolder() {
        return new PropertyAspectAdapter<Options, Boolean>(this.optionsHolder, new String[]{"includeDescriptorQueriesy"}){

            protected Boolean buildValue_() {
                return ((Options)this.subject).getIncludeDescriptorQueries();
            }

            protected void setValue_(Boolean value) {
                ((Options)this.subject).setIncludeDescriptorQueries(value);
            }
        };
    }

    private PropertyValueModel<String> buildIncludeDescriptorQueriesStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultIncludeDescriptorQueriesHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlOptionsTab_includeDescriptorQueriesLabelDefault, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlOptionsTab_includeDescriptorQueriesLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultIncludeDescriptorQueriesHolder() {
        return new PropertyAspectAdapter<Options, Boolean>(this.optionsHolder, new String[]{"includeDescriptorQueriesy"}){

            protected Boolean buildValue_() {
                if (((Options)this.subject).getIncludeDescriptorQueries() != null) {
                    return null;
                }
                return ((Options)this.subject).getDefaultIncludeDescriptorQueries();
            }
        };
    }

    protected ModifiablePropertyValueModel<Boolean> buildTemporalMutableHolder() {
        return new PropertyAspectAdapter<Options, Boolean>(this.optionsHolder, new String[]{"temporalMutable"}){

            protected Boolean buildValue_() {
                return ((Options)this.subject).getTemporalMutable();
            }

            protected void setValue_(Boolean value) {
                ((Options)this.subject).setTemporalMutable(value);
            }
        };
    }

    protected PropertyValueModel<String> buildTemporalMutableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultTemporalMutableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlOptionsTab_temporalMutableLabelDefault, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlOptionsTab_temporalMutableLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultTemporalMutableHolder() {
        return new PropertyAspectAdapter<Options, Boolean>(this.optionsHolder, new String[]{"temporalMutable"}){

            protected Boolean buildValue_() {
                if (((Options)this.subject).getTemporalMutable() != null) {
                    return null;
                }
                return ((Options)this.subject).getDefaultTemporalMutable();
            }
        };
    }
}

