/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.actions;

import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.adapters.java.Type;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.wizards.PersistenceNatureWizard;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MakeEntityActionDelegate
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        IJavaProject javaProject = ((IType)((StructuredSelection)this.selection).getFirstElement()).getJavaProject();
        if (!DaliPlugin.hasPersistenceNature((IJavaProject)javaProject)) {
            PersistenceNatureWizard wizard = new PersistenceNatureWizard(javaProject);
            WizardDialog dialog = new WizardDialog(PersistenceUiPlugin.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
        for (IType type : (StructuredSelection)this.selection) {
            Type jdtType = new Type(type);
            jdtType.addAnnotation("Entity");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        boolean enabled = !selection.isEmpty();
        for (IType type : (StructuredSelection)this.selection) {
            enabled &= this.canBeEntity(type);
        }
        action.setEnabled(enabled);
    }

    private boolean canBeEntity(IType type) {
        Type jdtType = new Type(type);
        try {
            return type.isClass() && !type.isMember() && !jdtType.containsAnnotation("Entity", jdtType.createASTRoot());
        }
        catch (JavaModelException jme) {
            if (!jme.isDoesNotExist()) {
                PersistenceUiPlugin.log(jme);
            }
            return false;
        }
    }
}

