/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.Basic;
import org.eclipse.dali.core.Column;
import org.eclipse.dali.core.DaliFactory;
import org.eclipse.dali.core.FetchType;
import org.eclipse.dali.core.PersistentAttributeFlavor;
import org.eclipse.dali.core.adapters.IBasicModelAdapter;
import org.eclipse.dali.core.adapters.java.Attribute;
import org.eclipse.dali.core.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.IJavaDefaultPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.db.wrappers.TableWrapper;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaBasicModelAdapter
extends JavaPersistentAttributeFlavorModelAdapter
implements IBasicModelAdapter,
IJavaDefaultPersistentAttributeFlavorModelAdapter {
    private JavaColumnModelAdapter columnModelAdapter;
    private EnumAnnotationElementAdapter fetchTypeAdapter = new EnumAnnotationElementAdapter(this.buildFetchTypeInfo());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public JavaBasicModelAdapter() {
        this.columnModelAdapter = new JavaColumnModelAdapter();
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildFetchTypeInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String fetchType) {
                if (fetchType == null) {
                    return;
                }
                if (fetchType.equals("EAGER")) {
                    JavaBasicModelAdapter.this.getBasicFlavor().setFetchType(FetchType.EAGER_LITERAL);
                } else if (fetchType.equals("LAZY")) {
                    JavaBasicModelAdapter.this.getBasicFlavor().setFetchType(FetchType.LAZY_LITERAL);
                } else if (fetchType.equals(FetchType.DEFAULT_LITERAL.getName())) {
                    JavaBasicModelAdapter.this.getBasicFlavor().setFetchType(FetchType.DEFAULT_LITERAL);
                }
            }

            public String persValue() {
                FetchType fetchType = JavaBasicModelAdapter.this.getBasicFlavor().getFetchType();
                if (((Object)((Object)fetchType)).equals((Object)FetchType.EAGER_LITERAL)) {
                    return "EAGER";
                }
                if (((Object)((Object)fetchType)).equals((Object)FetchType.LAZY_LITERAL)) {
                    return "LAZY";
                }
                return FetchType.DEFAULT_LITERAL.getName();
            }

            public String enumClassName() {
                return "FetchType";
            }

            public String annotationElementName() {
                return "fetch";
            }

            public String annotationName() {
                return JavaBasicModelAdapter.this.flavorName();
            }

            public Member member() {
                return JavaBasicModelAdapter.this.getAttribute();
            }

            public String defaultValue() {
                return FetchType.DEFAULT_LITERAL.getName();
            }
        };
    }

    protected PersistentAttributeFlavor buildFlavor(boolean isDefault) {
        return DaliFactory.eINSTANCE.createBasic(this, isDefault);
    }

    protected void initialize() {
        super.initialize();
        Column column = DaliFactory.eINSTANCE.createColumn(this.columnModelAdapter, this.buildColumnContext());
        this.getBasicFlavor().setColumn(column);
    }

    private Column.ColumnContext buildColumnContext() {
        return new Column.ColumnContext(){

            public TableWrapper getExpectedTable() {
                return JavaBasicModelAdapter.this.getBasicFlavor().getPersistentTypeFlavor().getResolvedDBTable();
            }
        };
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersFetchType(astRoot);
        this.updatePersColumn(astRoot);
    }

    private void updatePersFetchType(CompilationUnit astRoot) {
        this.fetchTypeAdapter.updatePersElement(astRoot);
    }

    private void updatePersColumn(CompilationUnit astRoot) {
        this.columnModelAdapter.engage(this.getBasicFlavor().getColumn(), astRoot);
    }

    public void defaultChanged() {
        this.updateJavaDefault();
    }

    public void fetchTypeChanged() {
        this.updateJavaFetchType();
    }

    private void updateJavaDefault() {
        boolean persDefault;
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        boolean javaDefault = this.javaPersistentAttributeType(astRoot) == null;
        if (javaDefault == (persDefault = this.getBasicFlavor().isDefault())) {
            return;
        }
        if (persDefault) {
            this.removeAnnotation("Basic");
        } else {
            this.addMappingAnnotation("Basic");
        }
    }

    private void updateJavaFetchType() {
        this.fetchTypeAdapter.updateJavaElement();
    }

    private Basic getBasicFlavor() {
        return (Basic)this.getFlavor();
    }

    public String flavorName() {
        return "Basic";
    }

    public boolean defaultApplies(Attribute attribute) {
        IType type;
        String[][] resolvedType;
        if (attribute.isPrimitiveType()) {
            return true;
        }
        String typeName = Signature.getSignatureSimpleName((String)attribute.getTypeSignature());
        try {
            resolvedType = attribute.getJDTMember().getDeclaringType().resolveType(typeName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        if (resolvedType == null || resolvedType.length > 1) {
            return false;
        }
        String packageName = resolvedType[0][0];
        String fullyQualifiedTypeName = String.valueOf(packageName) + "." + typeName;
        if (this.isPrimitiveWrapperType(fullyQualifiedTypeName)) {
            return true;
        }
        if (this.isOtherJavaType(fullyQualifiedTypeName)) {
            return true;
        }
        try {
            type = attribute.getJDTMember().getCompilationUnit().getJavaProject().findType(fullyQualifiedTypeName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        if (type == null) {
            return false;
        }
        if (this.isEnumType(type)) {
            return true;
        }
        return this.implementsSerializable(type);
    }

    private boolean isPrimitiveWrapperType(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName.equals(String.class.getName())) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(Long.class.getName())) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(Byte.class.getName())) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(Character.class.getName())) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(Boolean.class.getName())) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(Float.class.getName())) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(Double.class.getName())) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(Integer.class.getName())) {
            return true;
        }
        return fullyQualifiedTypeName.equals(Short.class.getName());
    }

    private boolean isOtherJavaType(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName.equals("java.lang.String")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.math.BigInteger")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.math.BigDecimal")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.util.Date")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.util.Calendar")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.sql.Date")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.sql.Time")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals("java.sql.Timestamp")) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(byte[].class.getName())) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(Byte[].class.getName())) {
            return true;
        }
        if (fullyQualifiedTypeName.equals(char[].class.getName())) {
            return true;
        }
        return fullyQualifiedTypeName.equals(Character[].class.getName());
    }

    private boolean isEnumType(IType type) {
        try {
            return type.isEnum();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean implementsSerializable(IType type) {
        ITypeHierarchy hierarchy;
        try {
            hierarchy = type.newSupertypeHierarchy(null, null);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        IType[] allSuperInterfaces = hierarchy.getAllSuperInterfaces(type);
        int i = 0;
        while (i < allSuperInterfaces.length) {
            IType superInterface = allSuperInterfaces[i];
            if (superInterface.getFullyQualifiedName().equals("java.io.Serializable")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

