/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import java.util.Iterator;
import org.eclipse.dali.core.DaliFactory;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.Id;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.core.ManyToMany;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.core.PersistentTypeFlavor;
import org.eclipse.dali.core.ReferencePersistentAttributeFlavor;
import org.eclipse.dali.core.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.Attribute;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.adapters.java.NestedStringAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaJoinColumnModelAdapter
implements IJoinColumnModelAdapter {
    private JoinColumn joinColumn;
    private JoinColumnOwner owner;
    private NestedStringAnnotationElementAdapter specifiedNameAdapter;
    private StringAnnotationElementAdapter specifiedTableNameAdapter;
    private NestedStringAnnotationElementAdapter specifiedReferencedColumnNameAdapter;

    JavaJoinColumnModelAdapter(JoinColumnOwner owner) {
        this.owner = owner;
        this.specifiedNameAdapter = new NestedStringAnnotationElementAdapter(this.buildSpecifiedNameElementInfo());
        this.specifiedTableNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedTableNameElementInfo());
        this.specifiedReferencedColumnNameAdapter = new NestedStringAnnotationElementAdapter(this.buildSpecifiedReferencedColumnNameElementInfo());
    }

    protected JoinColumnOwner getOwner() {
        return this.owner;
    }

    public JoinColumn buildJoinColumn(Attribute attribute) {
        this.joinColumn = DaliFactory.eINSTANCE.createJoinColumn(this);
        return this.joinColumn;
    }

    protected String joinTableAnnotationElementName() {
        return "joinColumns";
    }

    private NestedStringAnnotationElementAdapter.NestedAnnotationElementInfo buildSpecifiedNameElementInfo() {
        return new NestedStringAnnotationElementAdapter.NestedAnnotationElementInfo(){

            public String outerAnnotationName() {
                return "JoinTable";
            }

            public String outerAnnotationElementName() {
                return JavaJoinColumnModelAdapter.this.joinTableAnnotationElementName();
            }

            public void setPersValue(String newValue) {
                JavaJoinColumnModelAdapter.this.joinColumn.setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaJoinColumnModelAdapter.this.joinColumn.getSpecifiedName();
            }

            public String annotationElementName() {
                return "name";
            }

            public String annotationName() {
                return "JoinColumn";
            }

            public Member member() {
                return JavaJoinColumnModelAdapter.this.attribute();
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedTableNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaJoinColumnModelAdapter.this.joinColumn.setSpecifiedTableName(newValue);
            }

            public String persValue() {
                return JavaJoinColumnModelAdapter.this.joinColumn.getSpecifiedTableName();
            }

            public String annotationElementName() {
                return "table";
            }

            public String annotationName() {
                return "JoinColumn";
            }

            public Member member() {
                return JavaJoinColumnModelAdapter.this.attribute();
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    private NestedStringAnnotationElementAdapter.NestedAnnotationElementInfo buildSpecifiedReferencedColumnNameElementInfo() {
        return new NestedStringAnnotationElementAdapter.NestedAnnotationElementInfo(){

            public String outerAnnotationName() {
                return "JoinTable";
            }

            public String outerAnnotationElementName() {
                return JavaJoinColumnModelAdapter.this.joinTableAnnotationElementName();
            }

            public void setPersValue(String newValue) {
                JavaJoinColumnModelAdapter.this.joinColumn.setSpecifiedReferencedColumnName(newValue);
            }

            public String persValue() {
                return JavaJoinColumnModelAdapter.this.joinColumn.getSpecifiedReferencedColumnName();
            }

            public String annotationElementName() {
                return "referencedColumnName";
            }

            public String annotationName() {
                return "JoinColumn";
            }

            public Member member() {
                return JavaJoinColumnModelAdapter.this.attribute();
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(astRoot);
        this.updatePersDefaultTableName();
        this.updatePersSpecifiedTableName(astRoot);
        this.updatePersDefaultReferencedColumnName();
        this.updatePersSpecifiedReferencedColumnName(astRoot);
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.joinColumn.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.joinColumn.setDefaultName(name);
        }
    }

    protected String defaultName() {
        ReferencePersistentAttributeFlavor flavor = this.getOwner().referenceMapping();
        PersistentAttribute attribute = flavor.getPersistentAttribute();
        Entity targetEntity = flavor.getResolvedTargetEntity();
        String referencedAttributeName = null;
        if (targetEntity != null) {
            String attributeName = this.owner.referenceMapping().getPersistentAttribute().getName();
            for (PersistentAttribute targetAttribute : targetEntity.getPersistentType().getAllPersistentAttributes()) {
                String mappedBy;
                if (targetAttribute.getFlavorKey() != "manyToMany" || (mappedBy = ((ManyToMany)targetAttribute.getFlavor()).getMappedBy()) == null || !mappedBy.equals(attributeName)) continue;
                referencedAttributeName = targetAttribute.getName();
                break;
            }
        }
        if (referencedAttributeName == null) {
            return String.valueOf(attribute.getPersistentTypeFlavor().getPersistentType().getName()) + "_" + this.defaultReferencedColumnName();
        }
        return String.valueOf(referencedAttributeName) + "_" + this.defaultReferencedColumnName();
    }

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultTableName() {
        String name = this.defaultTableName();
        String persName = this.joinColumn.getDefaultTableName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.joinColumn.setDefaultTableName(name);
        }
    }

    private void updatePersSpecifiedTableName(CompilationUnit astRoot) {
        this.specifiedTableNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultReferencedColumnName() {
        String name = this.defaultReferencedColumnName();
        String persName = this.joinColumn.getDefaultReferencedColumnName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.joinColumn.setDefaultReferencedColumnName(name);
        }
    }

    private void updatePersSpecifiedReferencedColumnName(CompilationUnit astRoot) {
        this.specifiedReferencedColumnNameAdapter.updatePersElement(astRoot);
    }

    protected String defaultReferencedColumnName() {
        ReferencePersistentAttributeFlavor flavor = this.owner.referenceMapping();
        PersistentType persistentType = flavor.getPersistentTypeFlavor().getPersistentType();
        return this.idNameFromPersistenType(persistentType);
    }

    protected String idNameFromPersistenType(PersistentType persistentType) {
        String targetIdName = null;
        if (persistentType != null) {
            Iterator i = persistentType.getAllPersistentAttributes().listIterator();
            while (i.hasNext()) {
                PersistentAttribute targetAttribute = (PersistentAttribute)i.next();
                if (!(targetAttribute.getFlavor() instanceof Id)) continue;
                targetIdName = ((Id)targetAttribute.getFlavor()).getColumn().getName();
                break;
            }
        }
        return targetIdName;
    }

    private String defaultTableName() {
        ReferencePersistentAttributeFlavor flavor = this.owner.referenceMapping();
        PersistentTypeFlavor persistentTypeFlavor = flavor.getPersistentTypeFlavor();
        if (persistentTypeFlavor.getKey() == Entity.Key.INSTANCE) {
            return ((Entity)persistentTypeFlavor).getTable().getName();
        }
        return null;
    }

    public void specifiedNameChanged() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    public void specifiedTableNameChanged() {
        this.specifiedTableNameAdapter.updateJavaElement();
    }

    public void specifiedReferencedColumnNameChanged() {
        this.specifiedReferencedColumnNameAdapter.updateJavaElement();
    }

    private Attribute attribute() {
        JavaPersistentAttributeModelAdapter modelAdapter = (JavaPersistentAttributeModelAdapter)this.owner.referenceMapping().getPersistentAttribute().getModelAdapter();
        return modelAdapter.getAttribute();
    }

    public ITextRange getTextRange() {
        return this.attribute().getTextRange("JoinColumn");
    }

    public ITextRange joinColumnTextRange() {
        return this.specifiedNameAdapter.getTextRange();
    }

    public ITextRange referencedColumnTextRange() {
        return this.specifiedReferencedColumnNameAdapter.getTextRange();
    }

    public static interface JoinColumnOwner {
        public ReferencePersistentAttributeFlavor referenceMapping();
    }
}

