/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dali.core.CascadeType;
import org.eclipse.dali.core.FetchType;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.PersistentAttributeFlavor;
import org.eclipse.dali.core.ReferencePersistentAttributeFlavor;
import org.eclipse.dali.core.adapters.IPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.IReferencePersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;

public abstract class JavaReferencePersistentAttributeFlavorModelAdapter
extends JavaPersistentAttributeFlavorModelAdapter
implements IReferencePersistentAttributeFlavorModelAdapter {
    private static final String TARGET_ENTITY_ELEMENT_NAME = "targetEntity";
    private static final String[] PRIMITIVE_TYPE_NAMES = new String[]{Boolean.TYPE.getName(), Character.TYPE.getName(), Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName()};
    private static final String[] PRIMITIVE_WRAPPER_TYPE_NAMES = new String[]{Boolean.class.getName(), Character.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName()};
    private static final String[] SIMPLE_TYPE_NAMES = new String[]{String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};
    private static final String[] CONTAINER_TYPE_NAMES = new String[]{Collection.class.getName(), Set.class.getName(), List.class.getName(), Map.class.getName()};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;

    protected JavaReferencePersistentAttributeFlavorModelAdapter() {
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersCascadeType((ReferencePersistentAttributeFlavor)this.getFlavor(), astRoot);
        this.updatePersFetchType((ReferencePersistentAttributeFlavor)this.getFlavor(), astRoot);
        this.updatePersDefaultTargetEntity((ReferencePersistentAttributeFlavor)this.getFlavor());
        this.updatePersSpecifiedTargetEntity((ReferencePersistentAttributeFlavor)this.getFlavor(), astRoot);
    }

    private void updatePersCascadeType(ReferencePersistentAttributeFlavor referenceMappingType, CompilationUnit astRoot) {
        CascadeType javaCascadeType = this.javaCascadeType(referenceMappingType, astRoot);
        CascadeType persCascadeType = referenceMappingType.getCascadeType();
        if (javaCascadeType != null && javaCascadeType != persCascadeType) {
            referenceMappingType.setCascadeType(javaCascadeType);
        }
    }

    private void updatePersFetchType(ReferencePersistentAttributeFlavor persistentAttributeType, CompilationUnit astRoot) {
        FetchType javaFetchType = this.javaFetchType(astRoot);
        FetchType persFetchType = persistentAttributeType.getFetchType();
        if (javaFetchType != null && javaFetchType != persFetchType) {
            persistentAttributeType.setFetchType(javaFetchType);
        }
    }

    private void updatePersSpecifiedTargetEntity(ReferencePersistentAttributeFlavor referenceMappingType, CompilationUnit astRoot) {
        String javaSpecifiedTargetEntity = this.javaSpecifiedTargetEntity(referenceMappingType, astRoot);
        String persSpecifiedTargetEntity = referenceMappingType.getSpecifiedTargetEntity();
        if (javaSpecifiedTargetEntity == null || !javaSpecifiedTargetEntity.equals(persSpecifiedTargetEntity)) {
            referenceMappingType.setSpecifiedTargetEntity(javaSpecifiedTargetEntity);
        }
    }

    private void updatePersDefaultTargetEntity(ReferencePersistentAttributeFlavor referenceMappingType) {
        String javaDefaultTargetEntity = this.javaDefaultTargetEntity();
        String persDefaultTargetEntity = referenceMappingType.getDefaultTargetEntity();
        if (javaDefaultTargetEntity == null || !javaDefaultTargetEntity.equals(persDefaultTargetEntity)) {
            referenceMappingType.setDefaultTargetEntity(javaDefaultTargetEntity);
        }
    }

    public void cascadeTypeChanged() {
        this.updateJavaCascadeType();
    }

    public void specifiedTargetEntityChanged() {
        this.updateJavaSpecifiedTargetEntity();
    }

    public void fetchTypeChanged() {
        this.updateJavaFetchType();
    }

    protected ReferencePersistentAttributeFlavor getReferencePersistentAttributeFlavor() {
        return (ReferencePersistentAttributeFlavor)this.getFlavor();
    }

    private void updateJavaSpecifiedTargetEntity() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        final String persSpecifiedTargetEntity = this.getReferencePersistentAttributeFlavor().getSpecifiedTargetEntity();
        String javaSpecifiedTargetEntity = this.javaSpecifiedTargetEntity(this.getReferencePersistentAttributeFlavor(), astRoot);
        if (persSpecifiedTargetEntity == null && javaSpecifiedTargetEntity == null) {
            return;
        }
        if (persSpecifiedTargetEntity != null && persSpecifiedTargetEntity.equals(javaSpecifiedTargetEntity)) {
            return;
        }
        final String annotationName = this.flavorName();
        if (persSpecifiedTargetEntity == null || persSpecifiedTargetEntity.equals("")) {
            if (this.containsAnnotationElement(annotationName, TARGET_ENTITY_ELEMENT_NAME, astRoot)) {
                this.removeAnnotationElementNamed(annotationName, TARGET_ENTITY_ELEMENT_NAME);
            }
            return;
        }
        if (!this.getReferencePersistentAttributeFlavor().isValidTargetEntity(persSpecifiedTargetEntity)) {
            throw new IllegalArgumentException("targetEntity is not valid");
        }
        this.getAttribute().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation annotation = ASTTools.getAnnotation(bodyDeclaration, annotationName);
                AST ast = bodyDeclaration.getAST();
                if (annotation.isNormalAnnotation()) {
                    List values = ((NormalAnnotation)annotation).values();
                    boolean hasName = false;
                    Iterator i = values.listIterator();
                    while (i.hasNext()) {
                        MemberValuePair valuePair = (MemberValuePair)i.next();
                        if (!valuePair.getName().getFullyQualifiedName().equals(JavaReferencePersistentAttributeFlavorModelAdapter.TARGET_ENTITY_ELEMENT_NAME)) continue;
                        hasName = true;
                        Name name = ast.newName(persSpecifiedTargetEntity);
                        TypeLiteral typeLiteral = ast.newTypeLiteral();
                        typeLiteral.setType((Type)ast.newSimpleType(name));
                        valuePair.setValue((Expression)typeLiteral);
                    }
                    if (!hasName) {
                        MemberValuePair valuePair = ast.newMemberValuePair();
                        valuePair.setName(ast.newSimpleName(JavaReferencePersistentAttributeFlavorModelAdapter.TARGET_ENTITY_ELEMENT_NAME));
                        TypeLiteral typeLiteral = ast.newTypeLiteral();
                        typeLiteral.setType((Type)ast.newSimpleType(ast.newName(persSpecifiedTargetEntity)));
                        valuePair.setValue((Expression)typeLiteral);
                        ASTTools.addValuePair((NormalAnnotation)annotation, valuePair);
                    }
                } else {
                    NormalAnnotation normalAnnotation = ASTTools.newNormalAnnotation(ast, annotationName);
                    MemberValuePair valuePair = ast.newMemberValuePair();
                    valuePair.setName(ast.newSimpleName(JavaReferencePersistentAttributeFlavorModelAdapter.TARGET_ENTITY_ELEMENT_NAME));
                    TypeLiteral typeLiteral = ast.newTypeLiteral();
                    typeLiteral.setType((Type)ast.newSimpleType(ast.newName(persSpecifiedTargetEntity)));
                    valuePair.setValue((Expression)typeLiteral);
                    normalAnnotation.values().add(valuePair);
                    ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)normalAnnotation);
                }
            }
        });
    }

    private void updateJavaCascadeType() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        CascadeType persCascadeType = this.getReferencePersistentAttributeFlavor().getCascadeType();
        CascadeType javaCascadeType = this.javaCascadeType(this.getReferencePersistentAttributeFlavor(), astRoot);
        if (javaCascadeType == persCascadeType) {
            return;
        }
        String annotationName = this.flavorName();
        if (persCascadeType.getValue() == 0) {
            if (this.containsAnnotationElement(annotationName, "cascade", astRoot)) {
                this.removeAnnotationElementNamed(annotationName, "cascade");
            }
        } else {
            if (!this.containsAnnotation(annotationName, astRoot)) {
                this.addMappingAnnotation("Basic");
            }
            if (persCascadeType.getValue() == 1) {
                this.setCascadeType(annotationName, "ALL");
            } else if (persCascadeType.getValue() == 3) {
                this.setCascadeType(annotationName, "MERGE");
            } else if (persCascadeType.getValue() == 2) {
                this.setCascadeType(annotationName, "PERSIST");
            } else if (persCascadeType.getValue() == 5) {
                this.setCascadeType(annotationName, "REFRESH");
            } else if (persCascadeType.getValue() == 4) {
                this.setCascadeType(annotationName, "REMOVE");
            }
        }
    }

    private void updateJavaFetchType() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        FetchType persFetchType = this.getReferencePersistentAttributeFlavor().getFetchType();
        FetchType javaFetchType = this.javaFetchType(astRoot);
        if (javaFetchType == persFetchType) {
            return;
        }
        String annotationName = this.flavorName();
        if (persFetchType.getValue() == 0) {
            if (this.containsAnnotationElement(annotationName, "fetch", astRoot)) {
                this.removeAnnotationElementNamed(annotationName, "fetch");
            }
        } else if (persFetchType.getValue() == 1) {
            this.setFetchType(annotationName, "EAGER");
        } else {
            this.setFetchType(annotationName, "LAZY");
        }
    }

    public String fullyQualifyTargetEntity(String specifiedTargetEntity) {
        String[][] resolvedType;
        if (specifiedTargetEntity == null) {
            return null;
        }
        try {
            resolvedType = this.getType().resolveType(specifiedTargetEntity);
        }
        catch (JavaModelException javaModelException) {
            return specifiedTargetEntity;
        }
        if (resolvedType == null) {
            return specifiedTargetEntity;
        }
        if (resolvedType.length == 1) {
            if (resolvedType[0][0].equals("")) {
                return resolvedType[0][1];
            }
            return String.valueOf(resolvedType[0][0]) + "." + resolvedType[0][1];
        }
        return specifiedTargetEntity;
    }

    private CascadeType javaCascadeType(PersistentAttributeFlavor persistentAttributeType, CompilationUnit astRoot) {
        if (this.containsAnnotationElement(persistentAttributeType.flavorName(), "cascade", astRoot)) {
            String cascadeType = this.getAnnotationElementString("cascade", astRoot);
            if (cascadeType == null) {
                return null;
            }
            if (cascadeType.equals("ALL")) {
                return CascadeType.ALL_LITERAL;
            }
            if (cascadeType.equals("MERGE")) {
                return CascadeType.MERGE_LITERAL;
            }
            if (cascadeType.equals("PERSIST")) {
                return CascadeType.PERSIST_LITERAL;
            }
            if (cascadeType.equals("REFRESH")) {
                return CascadeType.REFRESH_LITERAL;
            }
            if (cascadeType.equals("REMOVE")) {
                return CascadeType.REMOVE_LITERAL;
            }
            return null;
        }
        return CascadeType.DEFAULT_LITERAL;
    }

    private String javaSpecifiedTargetEntity(PersistentAttributeFlavor persistentAttributeType, CompilationUnit astRoot) {
        MemberValuePair valuePair = ASTTools.getMemberValuePair(this.getAttribute().bodyDeclaration(astRoot), ((IPersistentAttributeFlavorModelAdapter)persistentAttributeType.getModelAdapter()).flavorName(), TARGET_ENTITY_ELEMENT_NAME);
        if (valuePair != null && valuePair.getValue().getNodeType() == 57) {
            TypeLiteral typeLiteral = (TypeLiteral)valuePair.getValue();
            Type type = typeLiteral.getType();
            if (type.isSimpleType()) {
                return ((SimpleType)type).getName().getFullyQualifiedName();
            }
            if (type.isPrimitiveType()) {
                return ((PrimitiveType)type).getPrimitiveTypeCode().toString();
            }
            if (type.isQualifiedType()) {
                Type qualifier = ((QualifiedType)type).getQualifier();
                SimpleName name = ((QualifiedType)type).getName();
                if (qualifier.isSimpleType()) {
                    return String.valueOf(((SimpleType)qualifier).getName().getFullyQualifiedName()) + "." + name.getFullyQualifiedName();
                }
            }
        }
        return null;
    }

    protected String javaDefaultTargetEntity() {
        return this.javaDefaultTargetEntity(this.getAttribute().getTypeSignature());
    }

    protected String javaDefaultTargetEntity(String typeSignature) {
        return this.buildReferenceEntityTypeName(typeSignature);
    }

    protected String buildReferenceEntityTypeName(String typeSignature) {
        String packageName;
        if (Signature.getArrayCount((String)typeSignature) > 0) {
            return null;
        }
        String typeName = Signature.getSignatureSimpleName((String)typeSignature);
        String qualifier = Signature.getSignatureQualifier((String)typeSignature);
        if (qualifier.length() > 0) {
            typeName = String.valueOf(qualifier) + "." + typeName;
        }
        String[][] resolvedTypes = null;
        try {
            resolvedTypes = this.getType().resolveType(typeName);
        }
        catch (JavaModelException javaModelException) {}
        if (resolvedTypes != null && resolvedTypes.length == 1 && (packageName = resolvedTypes[0][0]).length() != 0) {
            typeName = String.valueOf(packageName) + "." + resolvedTypes[0][1];
        }
        if (JavaReferencePersistentAttributeFlavorModelAdapter.typeNamedIsBasic(typeName)) {
            return null;
        }
        return typeName;
    }

    private static boolean typeNamedIsBasic(String typeName) {
        if (CollectionTools.contains((Object[])PRIMITIVE_TYPE_NAMES, (Object)typeName)) {
            return true;
        }
        if (CollectionTools.contains((Object[])PRIMITIVE_WRAPPER_TYPE_NAMES, (Object)typeName)) {
            return true;
        }
        return CollectionTools.contains((Object[])SIMPLE_TYPE_NAMES, (Object)typeName);
    }

    protected static boolean typeNamedIsContainer(String typeName) {
        return CollectionTools.contains((Object[])CONTAINER_TYPE_NAMES, (Object)typeName);
    }

    private void setCascadeType(String mappingAnnotation, String cascadeType) {
        this.getAttribute().setMappingAnnotationElementValuePair(mappingAnnotation, "cascade", "CascadeType", cascadeType);
    }

    private FetchType javaFetchType(CompilationUnit astRoot) {
        if (this.containsAnnotationElement(this.getFlavor().flavorName(), "fetch", astRoot)) {
            String fetchType = this.getAnnotationElementString("fetch", astRoot);
            if (fetchType == null) {
                return null;
            }
            if (fetchType.equals("EAGER")) {
                return FetchType.EAGER_LITERAL;
            }
            if (fetchType.equals("LAZY")) {
                return FetchType.LAZY_LITERAL;
            }
            return null;
        }
        return FetchType.DEFAULT_LITERAL;
    }

    private void setFetchType(String mappingAnnotation, String fetchType) {
        this.getAttribute().setMappingAnnotationElementValuePair(mappingAnnotation, "fetch", "FetchType", fetchType);
    }

    public ITextRange targetEntityTextRange() {
        MemberValuePair valuePair = this.getAttribute().getMemberValuePair(this.flavorName(), TARGET_ENTITY_ELEMENT_NAME);
        if (valuePair != null) {
            return ASTTools.getTextRange((ASTNode)valuePair);
        }
        return null;
    }
}

