/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.Embeddable;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.TypeMapping;
import org.eclipse.dali.core.adapters.IEmbeddableModelAdapter;
import org.eclipse.dali.core.adapters.java.IJavaTypeMappingModelAdapter;
import org.eclipse.dali.core.adapters.java.Type;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaEmbeddableModelAdapter
implements IEmbeddableModelAdapter,
IJavaTypeMappingModelAdapter {
    private Embeddable embeddable;
    private Type type;

    public JavaEmbeddableModelAdapter(Type type) {
        this.type = type;
    }

    public void engage(TypeMapping typeMapping, CompilationUnit astRoot) {
        this.embeddable = (Embeddable)typeMapping;
        this.updatePersModel(astRoot);
    }

    public void disengage() {
        this.embeddable = null;
    }

    public void addAnnotation() {
        CompilationUnit astRoot = this.type.createASTRoot();
        if (!this.type.containsAnnotation("Embeddable", astRoot)) {
            this.type.addAnnotation("Embeddable", astRoot);
        }
    }

    public void removeAnnotation() {
        CompilationUnit astRoot = this.type.createASTRoot();
        if (this.type.containsAnnotation("Embeddable", astRoot)) {
            this.type.removeAnnotation("Embeddable", astRoot);
        }
    }

    public Embeddable getEmbeddable() {
        return this.embeddable;
    }

    public ITextRange getTextRange() {
        return this.type.getTextRange(this.getEmbeddable().getAnnotationName());
    }

    private void updatePersModel(CompilationUnit astRoot) {
    }

    public void synchWithJavaDelta(IJavaElementDelta delta, CompilationUnit astRoot) {
        if ((delta.getFlags() & 1) != 0) {
            this.updatePersModel(astRoot);
        }
    }
}

