/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.AttributeMapping;
import org.eclipse.dali.core.Column;
import org.eclipse.dali.core.DaliFactory;
import org.eclipse.dali.core.GeneratedValue;
import org.eclipse.dali.core.GenerationType;
import org.eclipse.dali.core.Generator;
import org.eclipse.dali.core.IdMapping;
import org.eclipse.dali.core.adapters.IIdMappingModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaGeneratedValueModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaGeneratorModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaSequenceGeneratorModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaTableGeneratorModelAdapter;
import org.eclipse.dali.core.impl.GeneratorImpl;
import org.eclipse.dali.db.Table;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaIdMappingModelAdapter
extends JavaAttributeMappingModelAdapter
implements IIdMappingModelAdapter {
    private JavaGeneratedValueModelAdapter generatedValueModelAdapter;
    private JavaGeneratorModelAdapter generatorModelAdapter;
    private JavaColumnModelAdapter columnModelAdapter = new JavaColumnModelAdapter();

    private void initializeColumnModelAdapter() {
        Column column = DaliFactory.eINSTANCE.createColumn(this.columnModelAdapter, this.buildColumnContext());
        this.getIdModel().setColumn(column);
    }

    private Column.ColumnContext buildColumnContext() {
        return new Column.ColumnContext(){

            public Table getExpectedTable() {
                return JavaIdMappingModelAdapter.this.getIdModel().getTypeMapping().getResolvedDBTable();
            }
        };
    }

    private void initializeGeneratedValueModelAdapter() {
        this.generatedValueModelAdapter = new JavaGeneratedValueModelAdapter(this);
        GeneratedValue generatedValue = this.generatedValueModelAdapter.buildGeneratedValue();
        this.getIdModel().setGeneratedValue(generatedValue);
    }

    private void initializeGeneratorModelAdapter() {
        this.generatorModelAdapter = this.buildGeneratorModelAdapter();
        if (this.generatorModelAdapter != null) {
            Generator generator = this.generatorModelAdapter.buildGenerator();
            ((GeneratorImpl)generator).setSpecifiedNameGen("");
            this.getIdModel().setGenerator(generator);
        }
    }

    protected AttributeMapping buildAttributeMapping(boolean isDefault) {
        return DaliFactory.eINSTANCE.createIdMapping(this);
    }

    protected void initialize() {
        super.initialize();
        this.initializeColumnModelAdapter();
        this.initializeGeneratedValueModelAdapter();
        this.initializeGeneratorModelAdapter();
    }

    public void specifiedGeneratorNameChanged() {
        this.getGeneratedValueModelAdapter().specifiedGeneratorNameChanged();
    }

    public void strategyChanged() {
        this.generatorChanged();
    }

    public void generatorChanged() {
        this.updateJavaGenerator();
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.postUpdatePersModel(astRoot);
    }

    private void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersGeneratedValue(astRoot);
        this.updatePersGenerator(astRoot);
        this.updatePersColumn(astRoot);
    }

    void updatePersGenerator(CompilationUnit astRoot) {
        GenerationType persGenerationType = this.getGenerationType();
        if (persGenerationType.getValue() == 4 || persGenerationType.getValue() == 2) {
            this.getGeneratorModelAdapter().updatePersModel(astRoot);
        } else {
            this.generatorModelAdapter = null;
        }
    }

    private void updatePersColumn(CompilationUnit astRoot) {
        this.columnModelAdapter.engage(this.getIdModel().getColumn(), astRoot);
    }

    private void updatePersGeneratedValue(CompilationUnit astRoot) {
        this.getGeneratedValueModelAdapter().updatePersModel(astRoot);
    }

    private JavaGeneratedValueModelAdapter getGeneratedValueModelAdapter() {
        if (this.generatedValueModelAdapter == null) {
            this.initializeGeneratedValueModelAdapter();
        }
        return this.generatedValueModelAdapter;
    }

    private JavaGeneratorModelAdapter getGeneratorModelAdapter() {
        if (this.generatorModelAdapter == null) {
            this.initializeGeneratorModelAdapter();
        }
        return this.generatorModelAdapter;
    }

    private JavaGeneratorModelAdapter buildGeneratorModelAdapter() {
        GenerationType persGenerationType = this.getGenerationType();
        if (persGenerationType.getValue() == 4) {
            return new JavaTableGeneratorModelAdapter();
        }
        if (persGenerationType.getValue() == 2) {
            return new JavaSequenceGeneratorModelAdapter();
        }
        return null;
    }

    private void updateJavaGenerator() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        GenerationType persGenerationType = this.getGenerationType();
        this.initializeGeneratorModelAdapter();
        if (persGenerationType.getValue() == 4) {
            this.removeSequenceAnnotation(astRoot);
            if (!this.containsAnnotation("TableGenerator", astRoot)) {
                this.addMappingAnnotation("TableGenerator");
            }
        } else if (persGenerationType.getValue() == 2) {
            this.removeTableAnnotation(astRoot);
            if (!this.containsAnnotation("SequenceGenerator", astRoot)) {
                this.addMappingAnnotation("SequenceGenerator");
            }
        } else {
            this.removeTableAnnotation(astRoot);
            this.removeSequenceAnnotation(astRoot);
            this.generatorModelAdapter = null;
        }
    }

    private void removeTableAnnotation(CompilationUnit astRoot) {
        if (this.containsAnnotation("TableGenerator", astRoot)) {
            this.removeAnnotation("TableGenerator");
        }
    }

    private void removeSequenceAnnotation(CompilationUnit astRoot) {
        if (this.containsAnnotation("SequenceGenerator", astRoot)) {
            this.removeAnnotation("SequenceGenerator");
        }
    }

    private GenerationType getGenerationType() {
        return this.getIdModel().getGeneratedValue().getStrategy();
    }

    private IdMapping getIdModel() {
        return (IdMapping)this.getAttributeMapping();
    }

    public String attributeMappingName() {
        return "Id";
    }
}

