/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.ui.PersistenceManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class PersistenceUiPlugin
extends AbstractUIPlugin
implements IRegistryChangeListener {
    private static PersistenceUiPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.dali.ui";
    private PersistenceManager persistenceManager;

    public PersistenceUiPlugin() {
        plugin = this;
        this.persistenceManager = new PersistenceManager();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.verifyMappingExtensions();
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    private void verifyMappingExtensions() {
        Collection modelMappingAnntoations = CollectionTools.collection((Iterator)DaliPlugin.getPlugin().possibleAnnotationsMappings());
        Iterator uiMappingAnnotations = this.possibleMappingAnnotations();
        while (uiMappingAnnotations.hasNext()) {
            String annotationName = (String)uiMappingAnnotations.next();
            if (modelMappingAnntoations.contains(annotationName)) continue;
            throw new IllegalStateException("Must have an org.eclipse.dali.mapping extension in with the annotation name " + annotationName);
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] uiPluginDelta = event.getExtensionDeltas(PersistenceUiPlugin.getPluginId(), String.valueOf(PersistenceUiPlugin.getPluginId()) + ".mappings");
        if (uiPluginDelta != null) {
            this.verifyMappingExtensions();
        }
    }

    public Iterator mappingAnnotationConfigurationElements() {
        ArrayList<IConfigurationElement> mappingAnnotations = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(PersistenceUiPlugin.getPluginId()) + ".mappings");
        int j = 0;
        while (j < configurationElements.length) {
            String annotationName;
            IConfigurationElement configurationElement = configurationElements[j];
            if (configurationElement.getName().equals("mapping") && (annotationName = configurationElement.getAttribute("annotationName")) != null) {
                mappingAnnotations.add(configurationElement);
            }
            ++j;
        }
        return mappingAnnotations.iterator();
    }

    public Iterator possibleMappingAnnotations() {
        return new TransformationIterator(this.mappingAnnotationConfigurationElements()){

            protected Object transform(Object next) {
                return ((IConfigurationElement)next).getAttribute("annotationName");
            }
        };
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public static PersistenceUiPlugin getPlugin() {
        return plugin;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(Throwable e) {
        PersistenceUiPlugin.log((IStatus)new Status(4, PersistenceUiPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        PersistenceUiPlugin.getPlugin().getLog().log(status);
    }

    public static IWorkbenchPage getActivePage() {
        return PersistenceUiPlugin.getPlugin().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PersistenceUiPlugin.getPlugin().internalGetActiveWorkbenchWindow();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private IWorkbenchWindow internalGetActiveWorkbenchWindow() {
        return this.getWorkbench().getActiveWorkbenchWindow();
    }
}

