/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.Column;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.edit.ColumnItemProvider;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ColumnComposite
extends Composite
implements IPersistenceComposite {
    private Column column;
    private ColumnItemProvider columnItemProvider;
    private INotifyChangedListener columnListener;
    protected EditingDomain editingDomain;
    protected Combo columnCombo;
    protected boolean populating;
    static /* synthetic */ Class class$0;

    public ColumnComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory, String columnHelpContextId) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.columnItemProvider = (ColumnItemProvider)adapterFactory.createColumnAdapter();
        this.initializeLayout(columnHelpContextId);
    }

    private void initializeLayout(String columnHelpContextId) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        Label columnLabel = new Label((Composite)this, 16384);
        columnLabel.setText("Column:");
        this.columnCombo = this.buildColumnCombo(this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.columnCombo, "org.eclipse.dali.ui" + columnHelpContextId);
    }

    private Combo buildColumnCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add("Default()");
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ColumnComposite.this.populating) {
                    return;
                }
                String columnText = ((Combo)e.getSource()).getText();
                if (columnText.equals("")) {
                    columnText = null;
                    if (ColumnComposite.this.column.getSpecifiedName() == null || ColumnComposite.this.column.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (columnText != null && combo.getItemCount() > 0 && columnText.equals(combo.getItem(0))) {
                    columnText = null;
                }
                if (ColumnComposite.this.column.getSpecifiedName() == null || !ColumnComposite.this.column.getSpecifiedName().equals(columnText)) {
                    ColumnComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)ColumnComposite.this.editingDomain, (Object)ColumnComposite.this.column, (Object)DaliPackage.eINSTANCE.getColumn_SpecifiedName(), (Object)columnText));
                }
            }
        });
        return combo;
    }

    private INotifyChangedListener getColumnListener() {
        if (this.columnListener == null) {
            this.columnListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    ColumnComposite.this.columnChanged(notification);
                }
            };
        }
        return this.columnListener;
    }

    protected void columnChanged(Notification notification) {
        if (this.populating || notification.getNotifier() != this.column) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.Column");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 1) {
            final String columnName = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (ColumnComposite.this.columnCombo.getText() == null || !ColumnComposite.this.columnCombo.getText().equals(columnName)) {
                        if (columnName == null) {
                            ColumnComposite.this.columnCombo.select(0);
                        } else {
                            ColumnComposite.this.columnCombo.setText(columnName);
                        }
                    }
                }
            });
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.core.Column");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 0) {
                final String defaultColumnName = (String)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ColumnComposite.this.populating = true;
                        int selectionIndex = ColumnComposite.this.columnCombo.getSelectionIndex();
                        ColumnComposite.this.columnCombo.setItem(0, "Default (" + defaultColumnName + ")");
                        if (selectionIndex == 0) {
                            ColumnComposite.this.columnCombo.select(0);
                        }
                        ColumnComposite.this.populating = false;
                    }
                });
            }
        }
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.column != null) {
            this.columnItemProvider.removeListener(this.getColumnListener());
            this.column.eAdapters().remove((Object)this.columnItemProvider);
        }
        this.column = (Column)model;
        if (this.column == null) {
            return;
        }
        this.columnItemProvider.addListener(this.getColumnListener());
        this.column.eAdapters().add((Object)this.columnItemProvider);
        this.populateColumnCombo();
        this.populating = false;
    }

    private Table getTable() {
        return this.column.getColumnContext().getExpectedTable();
    }

    private void populateColumnCombo() {
        String columnName = this.column.getSpecifiedName();
        String defaultColumnName = this.column.getDefaultName();
        this.columnCombo.setItem(0, "Default (" + defaultColumnName + ")");
        if (this.column.getPersistenceProject() == null) {
            System.out.println("foo");
        }
        if (this.column.getPersistenceProject().getConnectionInfo() == null) {
            System.out.println("bar");
        }
        if (this.column.getPersistenceProject().getConnectionInfo().isConnected()) {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
            Table table = this.getTable();
            if (table != null) {
                Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)table.columnNames())).iterator();
                while (i.hasNext()) {
                    this.columnCombo.add((String)i.next());
                }
            }
        }
        if (columnName != null) {
            if (!this.columnCombo.getText().equals(columnName)) {
                this.columnCombo.setText(columnName);
            }
        } else if (!this.columnCombo.getText().equals("Default (" + defaultColumnName + ")")) {
            this.columnCombo.select(0);
        }
    }
}

