/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.PersistenceFile;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.ui.views.AbstractPersistenceView;
import org.eclipse.dali.ui.views.EmptyComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.MappingComposite;
import org.eclipse.dali.ui.views.PersistentTypeComposite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public final class PersistencePropertiesView
extends AbstractPersistenceView {
    private PageBook pageBook;
    private IPersistenceComposite visibleComposite;
    private EmptyComposite emptyComposite;
    private PersistentTypeComposite persistentTypeComposite;
    private MappingComposite mappingComposite;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.pageBook = new PageBook(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.pageBook.setLayoutData((Object)gridData);
        this.emptyComposite = new EmptyComposite((Composite)this.pageBook, "Persistence properties are not available. Selection is either not a persistence mapping or 'Persistence' have not been enabled for its project.");
        this.persistentTypeComposite = new PersistentTypeComposite((Composite)this.pageBook, (EditingDomain)this.editingDomain, this.adapterFactory);
        this.mappingComposite = new MappingComposite((Composite)this.pageBook, (EditingDomain)this.editingDomain, this.adapterFactory);
        this.visibleComposite = this.emptyComposite;
        this.pageBook.showPage((Control)this.emptyComposite);
    }

    void populate(EObject persistenceModel) {
        if (this.visibleComposite != null) {
            this.visibleComposite.populate(null);
        }
        this.visibleComposite = this.getPersistentCompositeFor(persistenceModel);
        this.pageBook.showPage((Control)((Composite)this.visibleComposite));
        this.visibleComposite.populate(persistenceModel);
    }

    private IPersistenceComposite getPersistentCompositeFor(EObject persistenceModel) {
        if (persistenceModel == null) {
            return this.emptyComposite;
        }
        if (persistenceModel instanceof PersistentType) {
            return this.persistentTypeComposite;
        }
        if (persistenceModel instanceof PersistentAttribute) {
            return this.mappingComposite;
        }
        return this.emptyComposite;
    }

    public void setFocus() {
        ((Composite)this.visibleComposite).setFocus();
    }

    void setPersistenceFile(PersistenceFile pFile) {
        if (pFile != null && pFile.getPersistentTypes().size() > 0) {
            this.populate((EObject)((PersistentType)pFile.getPersistentTypes().get(0)));
            return;
        }
        this.populate(null);
    }
}

