/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.actions;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dali.gen.EntityGenerator;
import org.eclipse.dali.gen.PackageGenerator;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.actions.ProjectAction;
import org.eclipse.dali.ui.wizards.GenerateEntitiesWizard;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class GenerateEntitiesAction
extends ProjectAction {
    PersistenceProject persistenceProject;
    static /* synthetic */ Class class$0;

    protected void execute(final PersistenceProject project) {
        GenerateEntitiesWizard wizard = new GenerateEntitiesWizard(this.tables(project), this.getCurrentSelection());
        WizardDialog dialog = new WizardDialog(PersistenceUiPlugin.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        int returnCode = dialog.open();
        if (returnCode == 0) {
            final Collection selectedTables = wizard.getSelectedTables();
            final IPackageFragment packageFragment = wizard.getPackageFragment();
            WorkspaceJob job = new WorkspaceJob("Generating Entities"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask("", 1000);
                    PackageGenerator.Config packageConfig = GenerateEntitiesAction.this.buildPackageConfig(packageFragment);
                    monitor.worked(5);
                    EntityGenerator.Config entityConfig = GenerateEntitiesAction.this.buildEntityConfig(project);
                    monitor.worked(5);
                    PackageGenerator.generateEntities((PackageGenerator.Config)packageConfig, (EntityGenerator.Config)entityConfig, (Collection)selectedTables, (IProgressMonitor)monitor);
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    private Collection tables(PersistenceProject project) {
        return CollectionTools.collection((Iterator)project.getSchema().tables());
    }

    private PackageGenerator.Config buildPackageConfig(IPackageFragment packageFragment) {
        PackageGenerator.Config config = new PackageGenerator.Config();
        config.setPackageFragment(packageFragment);
        return config;
    }

    private EntityGenerator.Config buildEntityConfig(PersistenceProject pp) {
        EntityGenerator.Config config = new EntityGenerator.Config();
        config.setConvertToCamelCase(true);
        config.setFieldAccessType(true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Set");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        config.setCollectionTypeName(clazz.getName());
        config.setFieldVisibility(0);
        config.setMethodVisibility(3);
        config.setGenerateGettersAndSetters(true);
        config.setGenerateDefaultConstructor(true);
        config.setSerializable(true);
        config.setGenerateSerialVersionUID(true);
        return config;
    }
}

