/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.wizards.JPAProjectFieldData;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class JPAProjectCreationPage
extends WizardNewProjectCreationPage {
    private JPAProjectFieldData fieldData;
    private JREGroup jreGroup;
    private LayoutGroup layoutGroup;

    public JPAProjectCreationPage(String pageName, JPAProjectFieldData jpaProjectFieldData) {
        super(pageName);
        this.fieldData = jpaProjectFieldData;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        GridLayout layout = new GridLayout();
        control.setLayout((Layout)layout);
        this.jreGroup = new JREGroup(control);
        this.layoutGroup = new LayoutGroup(control);
        Dialog.applyDialogFont((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.dali.ui.dialog_addJavaPersistence");
        this.setControl((Control)control);
    }

    private Button createButton(Composite container, int style, int span, int indent) {
        Button button = new Button(container, style);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        button.setLayoutData((Object)gd);
        return button;
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private final class JREGroup {
        private final Group group;
        private final Button useDefaultJREButton;
        private final Button useProjectJREButton;
        private final Combo jreCombo;
        private String[] jreData;
        private String[] jreComplianceData;
        private final Link preferenceLink;
        private IVMInstall[] installedJVMs;

        public JREGroup(Composite composite) {
            this.group = new Group(composite, 0);
            this.group.setLayoutData((Object)new GridData(768));
            this.group.setLayout((Layout)JPAProjectCreationPage.this.initGridLayout(new GridLayout(3, false), true));
            this.group.setText(DaliUiMessages.JPAProjectCreationPage_jre);
            this.useDefaultJREButton = JPAProjectCreationPage.this.createButton((Composite)this.group, 16, 2, 0);
            this.useDefaultJREButton.setText(this.getDefaultJVMLabel());
            this.useDefaultJREButton.setSelection(true);
            this.useDefaultJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ JREGroup this$1;
                {
                    this.this$1 = jREGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    JREGroup.access$0(this.this$1);
                }
            });
            this.preferenceLink = new Link((Composite)this.group, 0);
            this.preferenceLink.setText(DaliUiMessages.JPAProjectCreationPage_jrePreferenceLink);
            this.preferenceLink.setFont(this.group.getFont());
            this.preferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.preferenceLink.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ JREGroup this$1;
                {
                    this.this$1 = jREGroup;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    JREGroup.access$1(this.this$1);
                }
            });
            this.useProjectJREButton = JPAProjectCreationPage.this.createButton((Composite)this.group, 16, 1, 0);
            this.useProjectJREButton.setText(DaliUiMessages.JPAProjectCreationPage_projectJreLabel);
            this.useProjectJREButton.setSelection(false);
            this.useProjectJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ JREGroup this$1;
                {
                    this.this$1 = jREGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    JREGroup.access$0(this.this$1);
                }
            });
            this.jreCombo = new Combo((Composite)this.group, 12);
            this.fillInstalledJREs();
            this.jreCombo.setLayoutData((Object)new GridData(1, 2, true, false));
            this.jreCombo.setEnabled(false);
        }

        private void handleEnablement() {
            this.jreCombo.setEnabled(this.useProjectJREButton.getSelection());
        }

        private void fillInstalledJREs() {
            String selectedItem = null;
            int selectionIndex = -1;
            if (this.useProjectJREButton.getSelection() && (selectionIndex = this.jreCombo.getSelectionIndex()) != -1) {
                selectedItem = this.jreCombo.getItems()[selectionIndex];
            }
            this.installedJVMs = this.getWorkspaceJREs();
            Arrays.sort(this.installedJVMs, new Comparator(this){
                final /* synthetic */ JREGroup this$1;
                {
                    this.this$1 = jREGroup;
                }

                public int compare(Object arg0, Object arg1) {
                    IVMInstall i0 = (IVMInstall)arg0;
                    IVMInstall i1 = (IVMInstall)arg1;
                    if (i1 instanceof IVMInstall2 && i0 instanceof IVMInstall2) {
                        String cc0 = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)i0), (String)"1.4");
                        String cc1 = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)i1), (String)"1.4");
                        int result = cc1.compareTo(cc0);
                        if (result == 0) {
                            result = i0.getName().compareTo(i1.getName());
                        }
                        return result;
                    }
                    return i0.getName().compareTo(i1.getName());
                }
            });
            selectionIndex = -1;
            this.jreData = new String[this.installedJVMs.length];
            this.jreComplianceData = new String[this.installedJVMs.length];
            int i = 0;
            while (i < this.installedJVMs.length) {
                this.jreData[i] = this.installedJVMs[i].getName();
                if (selectedItem != null && this.jreData[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                this.jreComplianceData[i] = this.installedJVMs[i] instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)this.installedJVMs[i]), (String)"1.4") : "1.4";
                ++i;
            }
            this.jreCombo.setItems(this.jreData);
            if (selectionIndex == -1) {
                String selection = this.getDefaultJVMName();
                int i2 = 0;
                while (i2 < this.jreData.length) {
                    if (this.jreData[i2].equals(selection)) {
                        this.jreCombo.select(i2);
                    }
                    ++i2;
                }
            } else {
                String selection = selectedItem;
                int i3 = 0;
                while (i3 < this.jreData.length) {
                    if (this.jreData[i3].equals(selection)) {
                        this.jreCombo.select(i3);
                    }
                    ++i3;
                }
            }
        }

        private IVMInstall[] getWorkspaceJREs() {
            ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstallType type = types[i];
                IVMInstall[] installs = type.getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    IVMInstall install = installs[j];
                    standins.add(new VMStandin(install));
                    ++j;
                }
                ++i;
            }
            return standins.toArray(new IVMInstall[standins.size()]);
        }

        private String getDefaultJVMName() {
            return JavaRuntime.getDefaultVMInstall().getName();
        }

        private String getDefaultJVMLabel() {
            return MessageFormat.format(DaliUiMessages.JPAProjectCreationPage_defaultJreLabel, this.getDefaultJVMName());
        }

        private void promptToInstallJVMs() {
            String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)JPAProjectCreationPage.this.getShell(), (String)jreID, (String[])new String[]{jreID, complianceId}, data).open();
            this.handlePossibleJVMChange();
        }

        private void handlePossibleJVMChange() {
            this.useDefaultJREButton.setText(this.getDefaultJVMLabel());
            this.fillInstalledJREs();
        }

        public IVMInstall getSelectedJVM() {
            int index;
            if (this.useProjectJREButton.getSelection() && (index = this.jreCombo.getSelectionIndex()) >= 0 && index < this.jreComplianceData.length) {
                return this.installedJVMs[index];
            }
            return null;
        }

        public String getSelectedCompilerCompliance() {
            int index;
            if (this.useProjectJREButton.getSelection() && (index = this.jreCombo.getSelectionIndex()) >= 0 && index < this.jreComplianceData.length) {
                return this.jreComplianceData[index];
            }
            return null;
        }

        static /* synthetic */ void access$0(JREGroup jREGroup) {
            jREGroup.handleEnablement();
        }

        static /* synthetic */ void access$1(JREGroup jREGroup) {
            jREGroup.promptToInstallJVMs();
        }
    }

    private final class LayoutGroup {
        private final Group group;
        private final Button useProjectButton;
        private final Button useFoldersButton;
        private final Link preferenceLink;

        public LayoutGroup(Composite composite) {
            this.group = new Group(composite, 0);
            this.group.setLayoutData((Object)new GridData(768));
            this.group.setLayout((Layout)JPAProjectCreationPage.this.initGridLayout(new GridLayout(3, false), true));
            this.group.setText(DaliUiMessages.JPAProjectCreationPage_layout);
            this.useProjectButton = JPAProjectCreationPage.this.createButton((Composite)this.group, 16, 3, 0);
            this.useProjectButton.setText(DaliUiMessages.JPAProjectCreationPage_useProjectLabel);
            this.useFoldersButton = JPAProjectCreationPage.this.createButton((Composite)this.group, 16, 2, 0);
            this.useFoldersButton.setText(DaliUiMessages.JPAProjectCreationPage_useFoldersLabel);
            this.preferenceLink = new Link((Composite)this.group, 0);
            this.preferenceLink.setText(DaliUiMessages.JPAProjectCreationPage_layoutPreferenceLink);
            this.preferenceLink.setLayoutData((Object)new GridData(3, 2, true, false));
            this.preferenceLink.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ LayoutGroup this$1;
                {
                    this.this$1 = layoutGroup;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    LayoutGroup.access$0(this.this$1);
                }
            });
            boolean useFolders = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
            this.useProjectButton.setSelection(!useFolders);
            this.useFoldersButton.setSelection(useFolders);
        }

        public boolean useFolders() {
            return this.useFoldersButton.getSelection();
        }

        private void promptToConfigureDefaultLayout() {
            String id = "org.eclipse.jdt.ui.preferences.BuildPathPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)JPAProjectCreationPage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
            JPAProjectCreationPage.this.jreGroup.handlePossibleJVMChange();
        }

        static /* synthetic */ void access$0(LayoutGroup layoutGroup) {
            layoutGroup.promptToConfigureDefaultLayout();
        }
    }
}

