/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.util.jdt;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class ASTTools {
    public static StringLiteral newStringLiteral(AST ast, String literalValue) {
        StringLiteral stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue(literalValue);
        return stringLiteral;
    }

    public static NormalAnnotation newNormalAnnotation(AST ast, String annotationName) {
        NormalAnnotation annotation = ast.newNormalAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName(annotationName));
        return annotation;
    }

    public static MarkerAnnotation newMarkerAnnotation(AST ast, String annotationName) {
        MarkerAnnotation annotation = ast.newMarkerAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName(annotationName));
        return annotation;
    }

    public static SingleMemberAnnotation newSingleMemberAnnotation(AST ast, String annotationName) {
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName(annotationName));
        return annotation;
    }

    public static boolean containsAnyAnnotation(BodyDeclaration bodyDeclaration, String[] annotationNames) {
        Iterator stream = bodyDeclaration.modifiers().iterator();
        while (stream.hasNext()) {
            IExtendedModifier modifier = (IExtendedModifier)stream.next();
            if (!modifier.isAnnotation() || !CollectionTools.contains((Object[])annotationNames, (Object)((Annotation)modifier).getTypeName().getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static Annotation annotation(BodyDeclaration bodyDeclaration, String annotationName) {
        Iterator stream = bodyDeclaration.modifiers().iterator();
        while (stream.hasNext()) {
            IExtendedModifier modifier = (IExtendedModifier)stream.next();
            if (!modifier.isAnnotation() || !((Annotation)modifier).getTypeName().getFullyQualifiedName().equals(annotationName)) continue;
            return (Annotation)modifier;
        }
        return null;
    }

    public static void addValuePair(NormalAnnotation annotation, MemberValuePair valuePair) {
        List list = (List)annotation.getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
        list.add(valuePair);
    }

    public static void addExpressionToArrayInitializer(ArrayInitializer arrayInitializer, Expression expression) {
        List list = (List)arrayInitializer.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
        list.add(expression);
    }

    public static void addLiteralMemberValuePair(NormalAnnotation annotation, String name, String value) {
        AST ast = annotation.getAST();
        List list = (List)annotation.getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
        MemberValuePair newValuePair = ast.newMemberValuePair();
        newValuePair.setName(ast.newSimpleName(name));
        newValuePair.setValue((Expression)ASTTools.newStringLiteral(ast, value));
        list.add(newValuePair);
    }

    public static void addAnnotation(BodyDeclaration bodyDeclaration, String annotationName) {
        ASTTools.addAnnotation(bodyDeclaration, (Annotation)ASTTools.newMarkerAnnotation(bodyDeclaration.getAST(), annotationName));
    }

    public static void addAnnotation(BodyDeclaration bodyDeclaration, Annotation annotation) {
        List list = (List)bodyDeclaration.getStructuralProperty((StructuralPropertyDescriptor)bodyDeclaration.getModifiersProperty());
        list.add(ASTTools.annotationLocation(bodyDeclaration), annotation);
    }

    public static void removeAnnotation(BodyDeclaration bodyDeclaration, String annotationName) {
        ASTTools.removeAnnotation(bodyDeclaration, ASTTools.annotation(bodyDeclaration, annotationName));
    }

    public static void removeAnnotation(BodyDeclaration bodyDeclaration, Annotation annotation) {
        List list = (List)bodyDeclaration.getStructuralProperty((StructuralPropertyDescriptor)bodyDeclaration.getModifiersProperty());
        list.remove(annotation);
    }

    public static void removeAnnotationElement(BodyDeclaration bodyDeclaration, String annotationName, String elementName) {
        Annotation annotation = ASTTools.annotation(bodyDeclaration, annotationName);
        ASTTools.removeAnnotationElement(bodyDeclaration, annotation, elementName);
    }

    public static void removeAnnotationElement(BodyDeclaration bodyDeclaration, Annotation annotation, String elementName) {
        MemberValuePair valuePairToRemove = ASTTools.memberValuePair(annotation, elementName);
        if (valuePairToRemove != null) {
            if (((NormalAnnotation)annotation).values().size() == 1) {
                MarkerAnnotation newAnnotation = ASTTools.newMarkerAnnotation(bodyDeclaration.getAST(), annotation.getTypeName().getFullyQualifiedName());
                List list = (List)bodyDeclaration.getStructuralProperty((StructuralPropertyDescriptor)bodyDeclaration.getModifiersProperty());
                int index = list.indexOf(annotation);
                list.set(index, newAnnotation);
            } else {
                ASTTools.removeValuePair((NormalAnnotation)annotation, valuePairToRemove);
            }
        }
    }

    public static void removeValuePair(NormalAnnotation annotation, String valuePairName) {
        ASTTools.removeValuePair(annotation, ASTTools.memberValuePair(annotation, valuePairName));
    }

    public static void removeValuePair(NormalAnnotation annotation, MemberValuePair valuePair) {
        List list = (List)annotation.getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
        list.remove(valuePair);
    }

    public static void removeFromArrayInitializer(ArrayInitializer arrayInitializer, int position) {
        List list = (List)arrayInitializer.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
        list.remove(position);
    }

    public static void removeFromArrayInitializer(ArrayInitializer arrayInitializer, Object object) {
        List list = (List)arrayInitializer.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
        list.remove(object);
    }

    public static int arrayInitializerSize(ArrayInitializer arrayInitializer) {
        return ((List)arrayInitializer.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY)).size();
    }

    public static void replaceAnnotation(BodyDeclaration bodyDeclaration, Annotation oldAnnotation, Annotation newAnnotation) {
        List list = (List)bodyDeclaration.getStructuralProperty((StructuralPropertyDescriptor)bodyDeclaration.getModifiersProperty());
        int index = list.indexOf(oldAnnotation);
        list.set(index, newAnnotation);
    }

    public static MemberValuePair memberValuePair(BodyDeclaration bodyDeclaration, String annotationName, String name) {
        return ASTTools.memberValuePair(ASTTools.annotation(bodyDeclaration, annotationName), name);
    }

    public static MemberValuePair memberValuePair(Annotation annotation, String elementName) {
        if (annotation != null && annotation.isNormalAnnotation()) {
            return ASTTools.memberValuePair((NormalAnnotation)annotation, elementName);
        }
        return null;
    }

    public static MemberValuePair memberValuePair(NormalAnnotation annotation, String elementName) {
        Iterator stream = annotation.values().iterator();
        while (stream.hasNext()) {
            MemberValuePair valuePair = (MemberValuePair)stream.next();
            if (!valuePair.getName().getFullyQualifiedName().equals(elementName)) continue;
            return valuePair;
        }
        return null;
    }

    public static boolean containsAnnotationElement(BodyDeclaration bodyDeclaration, String annotationName, String elementName) {
        Annotation annotation = ASTTools.annotation(bodyDeclaration, annotationName);
        if (elementName.equals("value") && annotation.isSingleMemberAnnotation()) {
            return ((SingleMemberAnnotation)annotation).getValue() != null;
        }
        return ASTTools.memberValuePair(annotation, elementName) != null;
    }

    public static String annotationElementStringValue(BodyDeclaration bodyDeclaration, String annotationName, String elementName) {
        return ASTTools.stringValue(ASTTools.annotationElement(bodyDeclaration, annotationName, elementName));
    }

    public static Expression annotationElement(BodyDeclaration bodyDeclaration, String annotationName, String elementName) {
        return ASTTools.element(ASTTools.annotation(bodyDeclaration, annotationName), elementName);
    }

    public static String elementStringValue(Annotation annotation, String elementName) {
        return ASTTools.stringValue(ASTTools.element(annotation, elementName));
    }

    public static Expression element(Annotation annotation, String elementName) {
        if (elementName.equals("value") && annotation.isSingleMemberAnnotation()) {
            return ((SingleMemberAnnotation)annotation).getValue();
        }
        MemberValuePair valuePair = ASTTools.memberValuePair(annotation, elementName);
        return valuePair == null ? null : valuePair.getValue();
    }

    public static String stringValue(MemberValuePair valuePair) {
        return ASTTools.stringValue(valuePair.getValue());
    }

    public static String stringValue(Expression expression) {
        if (expression.getNodeType() == 45) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        return null;
    }

    public static ITextRange textRange(final ASTNode astNode) {
        if (astNode == null) {
            throw new IllegalArgumentException("Cannot get the ITextRange of a null ASTNode");
        }
        return new ITextRange(){

            public int getLineNumber() {
                return ((CompilationUnit)astNode.getRoot()).getLineNumber(this.getOffset());
            }

            public int getOffset() {
                return astNode.getStartPosition();
            }

            public int getLength() {
                return astNode.getLength();
            }
        };
    }

    public static int annotationLocation(BodyDeclaration bodyDeclaration) {
        int count = 0;
        ListIterator i = bodyDeclaration.modifiers().listIterator();
        while (i.hasNext()) {
            IExtendedModifier modifier = (IExtendedModifier)i.next();
            if (modifier.isModifier()) break;
            ++count;
        }
        return count;
    }
}

