/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.Iterator;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.SingularOrPluralStringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public class SingularPluralTopLevelAnnotationAdapter {
    private AnnotationInfo info;

    protected SingularPluralTopLevelAnnotationAdapter(AnnotationInfo info) {
        this.info = info;
    }

    void modelElementAdded() {
        if (!(this.info.supportsDefault() && this.info.isDefault() || this.info.listSize() <= this.javaElementsSize(this.info.member().createASTRoot()))) {
            this.addEmptyElementToJava();
        }
    }

    int javaElementsSize(CompilationUnit astRoot) {
        MemberValuePair valueValuePair;
        Annotation singluarAnnotation = this.info.member().getAnnotation(this.info.singularAnnotationName(), astRoot);
        if (singluarAnnotation != null) {
            return 1;
        }
        Annotation pluralAnnotation = this.info.member().getAnnotation(this.info.pluralAnnotationName(), astRoot);
        Expression valueExpression = null;
        if (pluralAnnotation == null) {
            return 0;
        }
        if (pluralAnnotation.getNodeType() == 79) {
            valueExpression = ((SingleMemberAnnotation)pluralAnnotation).getValue();
        } else if (pluralAnnotation.getNodeType() == 77 && (valueValuePair = ASTTools.memberValuePair(pluralAnnotation, "value")) != null) {
            valueExpression = valueValuePair.getValue();
        }
        int numElements = 0;
        if (valueExpression != null) {
            if (valueExpression.getNodeType() == 77) {
                if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals(this.info.singularAnnotationName())) {
                    ++numElements;
                }
            } else if (valueExpression.getNodeType() == 4) {
                Iterator i = ((ArrayInitializer)valueExpression).expressions().iterator();
                while (i.hasNext()) {
                    Expression expression = (Expression)i.next();
                    if (expression.getNodeType() != 77 || !((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals(this.info.singularAnnotationName())) continue;
                    ++numElements;
                }
            }
        }
        return numElements;
    }

    private void addEmptyElementToJava() {
        this.info.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation singularAnnotation = ASTTools.annotation(bodyDeclaration, SingularPluralTopLevelAnnotationAdapter.this.info.singularAnnotationName());
                if (singularAnnotation != null) {
                    SingleMemberAnnotation pluralAnnotation = ASTTools.newSingleMemberAnnotation(bodyDeclaration.getAST(), SingularPluralTopLevelAnnotationAdapter.this.info.pluralAnnotationName());
                    ASTTools.replaceAnnotation(bodyDeclaration, singularAnnotation, (Annotation)pluralAnnotation);
                    ArrayInitializer arrayInitializer = bodyDeclaration.getAST().newArrayInitializer();
                    ASTTools.addExpressionToArrayInitializer(arrayInitializer, (Expression)singularAnnotation);
                    ASTTools.addExpressionToArrayInitializer(arrayInitializer, (Expression)ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), SingularPluralTopLevelAnnotationAdapter.this.info.singularAnnotationName()));
                    pluralAnnotation.setValue((Expression)arrayInitializer);
                } else {
                    Annotation pluralAnnotation = ASTTools.annotation(bodyDeclaration, SingularPluralTopLevelAnnotationAdapter.this.info.pluralAnnotationName());
                    if (pluralAnnotation != null) {
                        Expression valueExpression = SingularOrPluralStringAnnotationElementAdapter.getValueExpression(pluralAnnotation);
                        if (valueExpression.getNodeType() == 77) {
                            ArrayInitializer arrayInitializer = bodyDeclaration.getAST().newArrayInitializer();
                            ASTTools.addExpressionToArrayInitializer(arrayInitializer, valueExpression);
                            valueExpression = arrayInitializer;
                        }
                        if (valueExpression.getNodeType() == 4) {
                            ASTTools.addExpressionToArrayInitializer((ArrayInitializer)valueExpression, (Expression)ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), SingularPluralTopLevelAnnotationAdapter.this.info.singularAnnotationName()));
                        }
                    }
                }
            }
        });
    }

    void modelElementRemoved(int position) {
        int javaJoinColumnsSize = this.javaElementsSize(this.info.member().createASTRoot());
        if (javaJoinColumnsSize == this.info.listSize() || javaJoinColumnsSize == 0 && (this.info.supportsDefault() || this.info.isDefault())) {
            return;
        }
        this.removeJoinColumnFromJava(position);
    }

    private void removeJoinColumnFromJava(final int position) {
        this.info.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation joinColumnAnnotation = ASTTools.annotation(bodyDeclaration, SingularPluralTopLevelAnnotationAdapter.this.info.singularAnnotationName());
                if (joinColumnAnnotation != null) {
                    ASTTools.removeAnnotation(bodyDeclaration, joinColumnAnnotation);
                    return;
                }
                Annotation joinColumnsAnnotation = ASTTools.annotation(bodyDeclaration, SingularPluralTopLevelAnnotationAdapter.this.info.pluralAnnotationName());
                Expression valueExpression = SingularOrPluralStringAnnotationElementAdapter.getValueExpression(joinColumnsAnnotation);
                if (valueExpression != null) {
                    if (valueExpression.getNodeType() == 77) {
                        ASTTools.removeAnnotation(bodyDeclaration, SingularPluralTopLevelAnnotationAdapter.this.info.pluralAnnotationName());
                    } else if (valueExpression.getNodeType() == 4) {
                        if (((ArrayInitializer)valueExpression).expressions().size() == 1) {
                            ASTTools.removeAnnotation(bodyDeclaration, SingularPluralTopLevelAnnotationAdapter.this.info.pluralAnnotationName());
                        } else if (((ArrayInitializer)valueExpression).expressions().size() == 2) {
                            int positionToSave = position == 0 ? 1 : 0;
                            Annotation annotation = (Annotation)((ArrayInitializer)valueExpression).expressions().get(positionToSave);
                            ASTTools.removeFromArrayInitializer((ArrayInitializer)valueExpression, positionToSave);
                            ASTTools.replaceAnnotation(bodyDeclaration, joinColumnsAnnotation, annotation);
                        } else {
                            ASTTools.removeFromArrayInitializer((ArrayInitializer)valueExpression, position);
                        }
                    }
                }
            }
        });
    }

    Annotation annotationAt(int index) {
        MemberValuePair valueValuePair;
        Annotation singularAnnotation = this.info.member().getAnnotation(this.info.singularAnnotationName());
        if (singularAnnotation != null) {
            return singularAnnotation;
        }
        Annotation pluralAnnotation = this.info.member().getAnnotation(this.info.pluralAnnotationName());
        if (pluralAnnotation == null) {
            return null;
        }
        if (pluralAnnotation.isMarkerAnnotation()) {
            return pluralAnnotation;
        }
        Expression valueExpression = null;
        if (pluralAnnotation.isSingleMemberAnnotation()) {
            valueExpression = ((SingleMemberAnnotation)pluralAnnotation).getValue();
        } else if (pluralAnnotation.isNormalAnnotation() && (valueValuePair = ASTTools.memberValuePair(pluralAnnotation, "value")) != null) {
            valueExpression = valueValuePair.getValue();
        }
        if (valueExpression != null) {
            if (valueExpression.getNodeType() == 77) {
                if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals(this.info.singularAnnotationName())) {
                    return (NormalAnnotation)valueExpression;
                }
            } else if (valueExpression.getNodeType() == 4) {
                return (Annotation)((ArrayInitializer)valueExpression).expressions().get(index);
            }
        }
        return null;
    }

    public static interface AnnotationInfo {
        public boolean supportsDefault();

        public boolean isDefault();

        public int listSize();

        public String singularAnnotationName();

        public String pluralAnnotationName();

        public Member member();
    }
}

