/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Insertable;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.Updatable;
import org.eclipse.dali.orm.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.orm.impl.AbstractJoinColumnImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class JoinColumnImpl
extends AbstractJoinColumnImpl
implements JoinColumn {
    protected static final String DEFAULT_TABLE_NAME_EDEFAULT = null;
    protected String defaultTableName = DEFAULT_TABLE_NAME_EDEFAULT;
    protected static final String SPECIFIED_TABLE_NAME_EDEFAULT = null;
    protected String specifiedTableName = SPECIFIED_TABLE_NAME_EDEFAULT;
    protected static final String TABLE_NAME_EDEFAULT = null;
    protected static final Insertable INSERTABLE_EDEFAULT = Insertable.DEFAULT_LITERAL;
    protected Insertable insertable = INSERTABLE_EDEFAULT;
    protected static final Updatable UPDATABLE_EDEFAULT = Updatable.DEFAULT_LITERAL;
    protected Updatable updatable = UPDATABLE_EDEFAULT;

    protected JoinColumnImpl() {
    }

    protected JoinColumnImpl(IJoinColumnModelAdapter modelAdapter) {
        super(modelAdapter);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.JOIN_COLUMN;
    }

    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    public void setDefaultTableName(String newDefaultTableName) {
        String oldDefaultTableName = this.defaultTableName;
        this.defaultTableName = newDefaultTableName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldDefaultTableName, (Object)this.defaultTableName));
        }
    }

    public String getSpecifiedTableName() {
        return this.specifiedTableName;
    }

    public void setSpecifiedTableNameGen(String newSpecifiedTableName) {
        String oldSpecifiedTableName = this.specifiedTableName;
        this.specifiedTableName = newSpecifiedTableName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldSpecifiedTableName, (Object)this.specifiedTableName));
        }
    }

    public void setSpecifiedTableName(String newSpecifiedTableName) {
        this.setSpecifiedTableNameGen(newSpecifiedTableName);
        this.getJoinColumnModelAdapter().specifiedTableNameChanged();
    }

    public String getTableName() {
        return this.getSpecifiedTableName() == null ? this.getDefaultTableName() : this.getSpecifiedTableName();
    }

    public Insertable getInsertable() {
        return this.insertable;
    }

    public void setInsertableGen(Insertable newInsertable) {
        Insertable oldInsertable = this.insertable;
        Insertable insertable = this.insertable = newInsertable == null ? INSERTABLE_EDEFAULT : newInsertable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldInsertable, (Object)this.insertable));
        }
    }

    public void setInsertable(Insertable newInsertable) {
        this.setInsertableGen(newInsertable);
        this.getJoinColumnModelAdapter().insertableChanged();
    }

    public Updatable getUpdatable() {
        return this.updatable;
    }

    public void setUpdatableGen(Updatable newUpdatable) {
        Updatable oldUpdatable = this.updatable;
        Updatable updatable = this.updatable = newUpdatable == null ? UPDATABLE_EDEFAULT : newUpdatable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldUpdatable, (Object)this.updatable));
        }
    }

    public void setUpdatable(Updatable newUpdatable) {
        this.setUpdatableGen(newUpdatable);
        this.getJoinColumnModelAdapter().updatableChanged();
    }

    public Table getTable() {
        Schema schema = this.getPersistenceProject().getSchema();
        return schema == null ? null : schema.tableNamed(this.getTableName());
    }

    public Table getReferencedTable() {
        Entity entity = this.getOwner().relationshipMapping().getResolvedTargetEntity();
        if (entity != null) {
            Schema schema = this.getPersistenceProject().getSchema();
            String tableName = entity.getTable().getName();
            return schema == null ? null : schema.tableNamed(tableName);
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getDefaultTableName();
            }
            case 7: {
                return this.getSpecifiedTableName();
            }
            case 8: {
                return this.getTableName();
            }
            case 9: {
                return this.getInsertable();
            }
            case 10: {
                return this.getUpdatable();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setDefaultTableName((String)newValue);
                return;
            }
            case 7: {
                this.setSpecifiedTableName((String)newValue);
                return;
            }
            case 9: {
                this.setInsertable((Insertable)((Object)newValue));
                return;
            }
            case 10: {
                this.setUpdatable((Updatable)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setDefaultTableName(DEFAULT_TABLE_NAME_EDEFAULT);
                return;
            }
            case 7: {
                this.setSpecifiedTableName(SPECIFIED_TABLE_NAME_EDEFAULT);
                return;
            }
            case 9: {
                this.setInsertable(INSERTABLE_EDEFAULT);
                return;
            }
            case 10: {
                this.setUpdatable(UPDATABLE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return DEFAULT_TABLE_NAME_EDEFAULT == null ? this.defaultTableName != null : !DEFAULT_TABLE_NAME_EDEFAULT.equals(this.defaultTableName);
            }
            case 7: {
                return SPECIFIED_TABLE_NAME_EDEFAULT == null ? this.specifiedTableName != null : !SPECIFIED_TABLE_NAME_EDEFAULT.equals(this.specifiedTableName);
            }
            case 8: {
                return TABLE_NAME_EDEFAULT == null ? this.getTableName() != null : !TABLE_NAME_EDEFAULT.equals(this.getTableName());
            }
            case 9: {
                return this.insertable != INSERTABLE_EDEFAULT;
            }
            case 10: {
                return this.updatable != UPDATABLE_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (defaultTableName: ");
        result.append(this.defaultTableName);
        result.append(", specifiedTableName: ");
        result.append(this.specifiedTableName);
        result.append(", insertable: ");
        result.append((Object)this.insertable);
        result.append(", updatable: ");
        result.append((Object)this.updatable);
        result.append(')');
        return result.toString();
    }

    public void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        if (this.getOwner().relationshipMapping().getTypeMapping().getKey() == Entity.Key.INSTANCE) {
            this.addJoinColumnTableNotAssociatedWithOwningEntityProblemTo(problems);
            this.addUnresolvedJoinColumnProblemTo(problems);
            this.addUnresolvedReferencedColumnProblemTo(problems);
        }
    }

    private void addJoinColumnTableNotAssociatedWithOwningEntityProblemTo(List problems) {
        String tableName = this.getTableName();
        if (!this.containsString(this.getOwner().relationshipMapping().getTypeMapping().associatedTableIncludingInheritedNames(), tableName)) {
            problems.add(this.buildProblem(this.joinColumnTableNotAssociatedWithOwningEntityMessage(), this.getJoinColumnModelAdapter().tableNameTextRange()));
        }
    }

    private boolean containsString(Iterator iterator, String tableName) {
        while (iterator.hasNext()) {
            if (!(this.caseSensitive() ? tableName.equals(iterator.next()) : StringTools.stringsAreEqualIgnoreCase((String)tableName, (String)((String)iterator.next())))) continue;
            return true;
        }
        return false;
    }

    private boolean caseSensitive() {
        return false;
    }

    private IJoinColumnModelAdapter.JoinColumnOwner getOwner() {
        return this.getJoinColumnModelAdapter().getOwner();
    }

    protected String joinColumnTableNotAssociatedWithOwningEntityMessage() {
        return "The table " + this.getTableName() + " is not associated with the owning Entity";
    }

    private void addUnresolvedJoinColumnProblemTo(List problems) {
        String tableName;
        if (this.getPersistenceProject().getConnection().isConnected() && !this.columnResolves(tableName = this.getOwner().getTableName(this), this.getName())) {
            problems.add(this.buildProblem("The join column " + this.getName() + " cannot be found on the table " + tableName, this.joinColumnTextRange()));
        }
    }

    private void addUnresolvedReferencedColumnProblemTo(List problems) {
        String tableName;
        if (this.getPersistenceProject().getConnection().isConnected() && !this.columnResolves(tableName = this.getOwner().getReferencedTableName(this), this.getReferencedColumnName())) {
            problems.add(this.buildProblem("The referenced column " + this.getReferencedColumnName() + " cannot be found on the table " + tableName, this.referencedColumnTextRange()));
        }
    }

    public int indexInContainer() {
        return this.getJoinColumnModelAdapter().getOwner().index(this);
    }

    private IJoinColumnModelAdapter getJoinColumnModelAdapter() {
        return (IJoinColumnModelAdapter)this.getModelAdapter();
    }
}

