/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.FetchTypeDefaultLazy;
import org.eclipse.dali.orm.MultiRelationshipMapping;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.PersistentTypeItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.composites.OrderByComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.JoinTableComposite;
import org.eclipse.dali.ui.views.RelationshipMappingComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public abstract class MultiRelationshipMappingComposite
extends RelationshipMappingComposite
implements IPersistenceComposite {
    protected Combo mappedByCombo;
    protected JoinTableComposite joinTableComposite;
    protected OrderByComposite orderByComposite;
    private ConnectionListener connectionListener;
    private Entity targetEntity;
    private PersistentTypeItemProvider persistentTypeItemProvider;
    private INotifyChangedListener persistentTypeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected MultiRelationshipMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.persistentTypeItemProvider = (PersistentTypeItemProvider)adapterFactory.createPersistentTypeAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        TabFolder folder = new TabFolder((Composite)this, 128);
        Control generalControl = this.buildGeneralTab(folder);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText(DaliUiMessages.MultiRelationshipMappingComposite_general);
        generalTab.setControl(generalControl);
        Control joinTableControl = this.buildJoinTableTab(folder);
        TabItem joinTableTab = new TabItem(folder, 0);
        joinTableTab.setText(DaliUiMessages.MultiRelationshipMappingComposite_joinTable);
        joinTableTab.setControl(joinTableControl);
        folder.setSelection(0);
    }

    private Control buildGeneralTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label targetEntityLabel = new Label(composite, 16384);
        targetEntityLabel.setText(DaliUiMessages.MultiRelationshipMappingComposite_targetEntity);
        this.targetEntityCombo = this.buildTargetEntityCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.targetEntityCombo.setLayoutData((Object)gridData);
        this.buildTargetEntitySelectionButton(composite);
        Label cascadeTypeLabel = new Label(composite, 16384);
        cascadeTypeLabel.setText(DaliUiMessages.MultiRelationshipMappingComposite_cascadeType);
        this.cascadeTypeComboViewer = this.buildCascadeTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cascadeTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label fetchTypeLabel = new Label(composite, 16384);
        fetchTypeLabel.setText(DaliUiMessages.MultiRelationshipMappingComposite_fetchType);
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label mappedByLabel = new Label(composite, 16384);
        mappedByLabel.setText(DaliUiMessages.MultiRelationshipMappingComposite_mappedBy);
        this.mappedByCombo = this.buildMappedByCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mappedByCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mappedByCombo, "org.eclipse.dali.ui.mapping_mappedBy");
        this.orderByComposite = new OrderByComposite(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.orderByComposite.setLayoutData(gridData);
        return composite;
    }

    private Control buildJoinTableTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.joinTableComposite = new JoinTableComposite(composite, this.editingDomain, this.adapterFactory);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinTableComposite.setLayoutData(gridData);
        return composite;
    }

    protected ComboViewer buildFetchTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(FetchTypeDefaultLazy.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (MultiRelationshipMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    FetchTypeDefaultLazy fetchType = (FetchTypeDefaultLazy)selection.getFirstElement();
                    MultiRelationshipMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)MultiRelationshipMappingComposite.this.editingDomain, (Object)MultiRelationshipMappingComposite.this.relationshipMapping, (Object)OrmPackage.eINSTANCE.getMultiRelationshipMapping_FetchType(), (Object)fetchType));
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)viewer.getCombo(), "org.eclipse.dali.ui.mapping_fetchType");
        return viewer;
    }

    private Combo buildMappedByCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MultiRelationshipMappingComposite.this.populating) {
                    return;
                }
                String mappedBy = ((Combo)e.getSource()).getText();
                if (mappedBy.equals("")) {
                    mappedBy = null;
                    if (MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy() == null || MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy().equals("")) {
                        return;
                    }
                }
                if (MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy() == null || !MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy().equals(mappedBy)) {
                    MultiRelationshipMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)MultiRelationshipMappingComposite.this.editingDomain, (Object)MultiRelationshipMappingComposite.this.getMultiRelationshipMapping(), (Object)OrmPackage.eINSTANCE.getNonOwningMapping_MappedBy(), (Object)mappedBy));
                }
            }
        });
        return combo;
    }

    private MultiRelationshipMapping getMultiRelationshipMapping() {
        return (MultiRelationshipMapping)this.relationshipMapping;
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (this.mappedByCombo.getItemCount() > 0) {
            this.mappedByCombo.removeAll();
        }
        if (model != null) {
            this.populateMappedByCombo();
            this.populateJoinTablePanel();
            this.populateFetchTypeCombo();
        } else {
            this.unpopulateJoinTablePanel();
        }
        this.populating = false;
    }

    private void populateFetchTypeCombo() {
        if (this.getMultiRelationshipMapping().getFetchType() == FetchTypeDefaultLazy.DEFAULT_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchTypeDefaultLazy.DEFAULT_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchTypeDefaultLazy.DEFAULT_LITERAL));
            }
        } else if (this.getMultiRelationshipMapping().getFetchType() == FetchTypeDefaultLazy.EAGER_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchTypeDefaultLazy.EAGER_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchTypeDefaultLazy.EAGER_LITERAL));
            }
        } else if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchTypeDefaultLazy.LAZY_LITERAL) {
            this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchTypeDefaultLazy.LAZY_LITERAL));
        }
    }

    private void populateMappedByCombo() {
        Entity newTargetEntity = this.getMultiRelationshipMapping().getResolvedTargetEntity();
        if (newTargetEntity != this.targetEntity) {
            if (this.targetEntity != null) {
                this.persistentTypeItemProvider.removeListener(this.getPersistentTypeListener());
                this.targetEntity.getPersistentType().eAdapters().remove((Object)this.persistentTypeItemProvider);
            }
            this.targetEntity = newTargetEntity;
            if (this.targetEntity != null) {
                this.persistentTypeItemProvider.addListener(this.getPersistentTypeListener());
                this.targetEntity.getPersistentType().eAdapters().add((Object)this.persistentTypeItemProvider);
            }
        }
        String mappedBy = this.getMultiRelationshipMapping().getMappedBy();
        this.mappedByCombo.removeAll();
        Iterator i = this.getMultiRelationshipMapping().possibleMappedByAttributeNames();
        while (i.hasNext()) {
            this.mappedByCombo.add((String)i.next());
        }
        if (mappedBy != null && !this.mappedByCombo.getText().equals(mappedBy)) {
            this.mappedByCombo.setText(mappedBy);
        }
    }

    private void unpopulateJoinTablePanel() {
        this.joinTableComposite.populate(null);
    }

    private void populateJoinTablePanel() {
        this.addConnectionListener();
        if (this.getMultiRelationshipMapping() == null) {
            this.unpopulateJoinTablePanel();
        } else {
            this.joinTableComposite.populate((EObject)this.getMultiRelationshipMapping().getJoinTable());
        }
    }

    protected void mappingTypeChanged(Notification notification) {
        block20: {
            block22: {
                block21: {
                    block19: {
                        super.mappingTypeChanged(notification);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.dali.orm.MultiRelationshipMapping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (notification.getFeatureID((Class)clazz) != 8) break block19;
                        final FetchTypeDefaultLazy fetchType = (FetchTypeDefaultLazy)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                if (((StructuredSelection)MultiRelationshipMappingComposite.this.fetchTypeComboViewer.getSelection()).getFirstElement() != fetchType) {
                                    MultiRelationshipMappingComposite.this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)fetchType));
                                }
                            }
                        });
                        break block20;
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.orm.MultiRelationshipMapping");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) != 5) break block21;
                    final String mappedBy = (String)notification.getNewValue();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (MultiRelationshipMappingComposite.this.mappedByCombo.getText() == null || !MultiRelationshipMappingComposite.this.mappedByCombo.getText().equals(mappedBy)) {
                                if (mappedBy == null) {
                                    MultiRelationshipMappingComposite.this.mappedByCombo.setText("");
                                } else {
                                    MultiRelationshipMappingComposite.this.mappedByCombo.setText(mappedBy);
                                }
                            }
                        }
                    });
                    break block20;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dali.orm.MultiRelationshipMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz) == 2) break block22;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.MultiRelationshipMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz2) != 1) break block20;
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MultiRelationshipMappingComposite.this.populating = true;
                    MultiRelationshipMappingComposite.this.populateMappedByCombo();
                    MultiRelationshipMappingComposite.this.populating = false;
                }
            });
        }
    }

    private INotifyChangedListener getPersistentTypeListener() {
        if (this.persistentTypeListener == null) {
            this.persistentTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    MultiRelationshipMappingComposite.this.persistentTypeChanged(notification);
                }
            };
        }
        return this.persistentTypeListener;
    }

    private void persistentTypeChanged(Notification notification) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dali.orm.PersistentType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 3) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MultiRelationshipMappingComposite.this.populating = true;
                    MultiRelationshipMappingComposite.this.populateMappedByCombo();
                    MultiRelationshipMappingComposite.this.populating = false;
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        this.removeConnectionListener();
        this.joinTableComposite.dispose();
        this.orderByComposite.dispose();
    }

    private void addConnectionListener() {
        if (this.connectionListener == null) {
            Connection connection = this.relationshipMapping.getPersistenceProject().getConnection();
            this.connectionListener = this.buildConnectionListener(connection);
            connection.addConnectionListener(this.connectionListener);
        }
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            this.connectionListener.dispose();
            this.relationshipMapping.getPersistenceProject().getConnection().removeConnectionListener(this.connectionListener);
            this.connectionListener = null;
        }
    }

    private ConnectionListener buildConnectionListener(final Connection connectionInfo) {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    MultiRelationshipMappingComposite.this.populateJoinTablePanel();
                }
            }

            public void disconnected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    MultiRelationshipMappingComposite.this.populateJoinTablePanel();
                }
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                MultiRelationshipMappingComposite.this.populateJoinTablePanel();
            }

            public void tableChanged(Table table) {
                if (MultiRelationshipMappingComposite.this.getMultiRelationshipMapping() != null && MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getJoinTable().getDBTable() == table) {
                    MultiRelationshipMappingComposite.this.populateJoinTablePanel();
                }
            }

            public void databaseAdded(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    MultiRelationshipMappingComposite.this.populateJoinTablePanel();
                }
            }

            public void databaseRemove(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    MultiRelationshipMappingComposite.this.populateJoinTablePanel();
                }
            }

            public void onSQLException(Connection connection, SQLException exception) {
                connectionInfo.equals(connection);
            }

            public void dispose() {
            }
        };
    }
}

