/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor.style;

import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.property.XmlProperty;
import org.eclipse.wb.internal.core.xml.model.utils.NamespacesHelper;
import org.eclipse.wb.internal.xwt.model.property.editor.style.IStyleClassResolver;

public final class XwtStyleClassResolver
implements IStyleClassResolver {
    public static final IStyleClassResolver INSTANCE = new XwtStyleClassResolver();

    private XwtStyleClassResolver() {
    }

    @Override
    public String resolve(Property property, String className) {
        if (className.equals("org.eclipse.swt.SWT")) {
            return "";
        }
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        String namespace = XwtStyleClassResolver.getPackageNamespace(property, packageName);
        String shortClassName = StringUtils.substringAfterLast((String)className, (String)".");
        return "(" + namespace + ":" + shortClassName + ").";
    }

    private static String getPackageNamespace(Property property, String packageName) {
        XmlObjectInfo object = ((XmlProperty)property).getObject();
        DocumentElement element = object.getCreationSupport().getElement();
        return NamespacesHelper.ensureName((DocumentElement)element, (String)("clr-namespace:" + packageName), (String)"p");
    }
}

