/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import java.text.MessageFormat;
import org.eclipse.wb.internal.swt.model.ModelMessages;

public enum FormSide {
    LEFT{

        @Override
        public String getField() {
            return "left";
        }

        @Override
        public int getFormSide() {
            return 16384;
        }

        @Override
        public int getEngineSide() {
            return 1;
        }

        @Override
        public FormSide getOppositeSide() {
            return RIGHT;
        }
    }
    ,
    RIGHT{

        @Override
        public String getField() {
            return "right";
        }

        @Override
        public int getFormSide() {
            return 131072;
        }

        @Override
        public int getEngineSide() {
            return 4;
        }

        @Override
        public FormSide getOppositeSide() {
            return LEFT;
        }
    }
    ,
    TOP{

        @Override
        public String getField() {
            return "top";
        }

        @Override
        public int getFormSide() {
            return 128;
        }

        @Override
        public int getEngineSide() {
            return 8;
        }

        @Override
        public FormSide getOppositeSide() {
            return BOTTOM;
        }
    }
    ,
    BOTTOM{

        @Override
        public String getField() {
            return "bottom";
        }

        @Override
        public int getFormSide() {
            return 1024;
        }

        @Override
        public int getEngineSide() {
            return 32;
        }

        @Override
        public FormSide getOppositeSide() {
            return TOP;
        }
    };


    private FormSide() {
    }

    public abstract String getField();

    public abstract int getFormSide();

    public abstract int getEngineSide();

    public abstract FormSide getOppositeSide();

    public static FormSide get(int side) {
        if (side == 1) {
            return LEFT;
        }
        if (side == 4) {
            return RIGHT;
        }
        if (side == 8) {
            return TOP;
        }
        if (side == 32) {
            return BOTTOM;
        }
        throw new Error(MessageFormat.format(ModelMessages.FormSide_unknownSize, side));
    }

    /* synthetic */ FormSide(String string, int n, FormSide formSide) {
        this();
    }
}

