/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor.style.impl;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.BooleanPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.xwt.model.property.editor.style.StylePropertyEditor;
import org.eclipse.wb.internal.xwt.model.property.editor.style.SubStylePropertyImpl;
import org.eclipse.wb.internal.xwt.model.property.editor.style.actions.BooleanStyleAction;

public final class BooleanStylePropertyImpl
extends SubStylePropertyImpl {
    private final String m_sFlag;
    private final long m_flag;

    public BooleanStylePropertyImpl(StylePropertyEditor editor, String title, String sFlag, long flag) {
        super(editor, title);
        this.m_sFlag = sFlag;
        this.m_flag = flag;
    }

    @Override
    public PropertyEditor createEditor() {
        return BooleanPropertyEditor.INSTANCE;
    }

    @Override
    public long getFlag(String sFlag) {
        return this.m_flag;
    }

    @Override
    public String getFlagValue(Property property) throws Exception {
        return this.isSet(property) ? this.m_sFlag : null;
    }

    private boolean isSet(Property property) throws Exception {
        return (this.getStyle(property) & this.m_flag) != 0L;
    }

    @Override
    public Object getValue(Property property) throws Exception {
        return this.isSet(property) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setValue(Property property, Object value) throws Exception {
        boolean setValue = value != Property.UNKNOWN_VALUE && (Boolean)value != false;
        long style = this.getStyle(property);
        style = setValue ? (style |= this.m_flag) : (style ^= this.m_flag);
        this.setStyleValue(property, style);
    }

    @Override
    public void contributeActions(Property property, IMenuManager manager) throws Exception {
        BooleanStyleAction action = new BooleanStyleAction(property, this);
        action.setChecked(this.isSet(property));
        manager.add((IAction)action);
    }
}

