/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.model.AbstractComponentInfo;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.TopBoundsSupport;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeTopBoundsSupport;
import org.eclipse.wb.internal.xwt.model.widgets.WidgetInfo;
import org.eclipse.wb.internal.xwt.parser.XwtRenderer;
import org.eclipse.wb.internal.xwt.support.CoordinateUtils;
import org.eclipse.wb.internal.xwt.support.ToolkitSupport;
import org.eclipse.wb.os.OSSupportError;

public class ControlInfo
extends WidgetInfo
implements IControlInfo {
    public ControlInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
    }

    public final Control getControl() {
        return (Control)this.getObject();
    }

    protected TopBoundsSupport createTopBoundsSupport() {
        return new CompositeTopBoundsSupport(this);
    }

    public void refresh_dispose() throws Exception {
        Control control;
        if (this.isRoot() && (control = this.getControl()) != null && !control.isDisposed()) {
            control.getShell().dispose();
        }
        super.refresh_dispose();
    }

    protected void refresh_create() throws Exception {
        XwtRenderer renderer = new XwtRenderer(this);
        try {
            renderer.render();
        }
        finally {
            renderer.dispose();
        }
    }

    protected void refresh_afterCreate() throws Exception {
        this.setPreferredSize(CoordinateUtils.getPreferredSize(this.getControl()));
        super.refresh_afterCreate();
    }

    protected void refresh_fetch() throws Exception {
        ControlInfo.refresh_fetch(this, new RunnableEx(){

            public void run() throws Exception {
                ControlInfo.super.refresh_fetch();
            }
        });
    }

    public static void refresh_fetch(AbstractComponentInfo component, RunnableEx superRefreshFetch) throws Exception {
        Control control = (Control)component.getComponentObject();
        ControlInfo.refresh_fetch(component, control, superRefreshFetch);
    }

    public static void refresh_fetch(AbstractComponentInfo component, Control control, RunnableEx superRefreshFetch) throws Exception {
        boolean wasOSSupportError = false;
        try {
            try {
                if (component.isRoot()) {
                    ToolkitSupport.beginShot(control);
                    ControlInfo.createShotImages(component, control);
                }
                Rectangle modelBounds = CoordinateUtils.getBounds(control);
                component.setModelBounds(modelBounds);
                Rectangle bounds = modelBounds.getCopy();
                Control parentControl = ControlInfo.getParentControl(component);
                if (parentControl != null) {
                    Point controlLocation = CoordinateUtils.getDisplayLocation(control);
                    Point parentLocation = CoordinateUtils.getDisplayLocation(parentControl);
                    bounds.x = controlLocation.x - parentLocation.x;
                    bounds.y = controlLocation.y - parentLocation.y;
                }
                component.setBounds(bounds);
                if (control instanceof Composite) {
                    Composite composite = (Composite)control;
                    component.setClientAreaInsets(CoordinateUtils.getClientAreaInsets(composite));
                }
                if (superRefreshFetch != null) {
                    superRefreshFetch.run();
                }
            }
            catch (OSSupportError e) {
                wasOSSupportError = true;
                throw e;
            }
        }
        finally {
            if (component.isRoot() && !wasOSSupportError) {
                ToolkitSupport.endShot(control);
            }
        }
    }

    private static Control getParentControl(AbstractComponentInfo component) {
        ObjectInfo parent = component.getParent();
        while (parent instanceof AbstractComponentInfo) {
            Object parentObject = ((AbstractComponentInfo)parent).getComponentObject();
            if (parentObject instanceof Control) {
                return (Control)parentObject;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static void createShotImages(AbstractComponentInfo root, Control rootControl) throws Exception {
        root.accept(new ObjectInfoVisitor(){

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                AbstractComponentInfo componentInfo;
                Object componentObject;
                if (objectInfo instanceof AbstractComponentInfo && (componentObject = (componentInfo = (AbstractComponentInfo)objectInfo).getComponentObject()) instanceof Control) {
                    ToolkitSupport.markAsNeededImage((Control)componentObject);
                }
            }
        });
        ToolkitSupport.makeShots(rootControl);
        root.accept(new ObjectInfoVisitor(){

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                AbstractComponentInfo componentInfo;
                Object componentObject;
                if (objectInfo instanceof AbstractComponentInfo && (componentObject = (componentInfo = (AbstractComponentInfo)objectInfo).getComponentObject()) instanceof Control) {
                    Image image = ToolkitSupport.getShotImage((Control)componentObject);
                    componentInfo.setImage(image);
                }
            }
        });
    }

    protected final Image getLiveImage() {
        return this.getLiveComponentsManager().getImage();
    }

    protected final int getLiveBaseline() {
        return this.getLiveComponentsManager().getBaseline();
    }
}

