/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders;

import java.util.Collection;
import java.util.List;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.PropertyAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.ComboDialogField;

public final class ChooseClassAndPropertiesRouter {
    private final ChooseClassAndPropertiesUiContentProvider m_source;
    private final ChooseClassUiContentProvider m_target;

    public ChooseClassAndPropertiesRouter(ChooseClassAndPropertiesUiContentProvider source, ChooseClassUiContentProvider target) {
        this.m_source = source;
        this.m_target = target;
        source.setRouter(this);
    }

    void handle() {
        List<PropertyAdapter> properties = this.m_source.getChoosenProperties0();
        if (this.m_target instanceof ChooseClassAndPropertiesUiContentProvider) {
            ChooseClassAndPropertiesUiContentProvider target = (ChooseClassAndPropertiesUiContentProvider)this.m_target;
            target.getPropertiesViewer().setAllChecked(false);
        }
        if (properties.isEmpty()) {
            this.setClearValue(false);
        } else {
            Class<?> elementType = properties.get(0).getType();
            if (elementType.isPrimitive() || elementType.isArray()) {
                this.setClearValue(false);
            } else if (Collection.class.isAssignableFrom(elementType)) {
                this.setClearValue(true);
                ComboDialogField combo = (ComboDialogField)this.m_target.getDialogField();
                combo.removeItem("");
            } else {
                this.m_target.getDialogField().setEnabled(false);
                this.m_target.setClassName(elementType.getName());
            }
        }
    }

    private void setClearValue(boolean enabled) {
        this.m_target.getDialogField().setEnabled(enabled);
        this.m_target.setClearClassName();
    }
}

