/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.java6.model;

import java.awt.Component;
import java.awt.Dimension;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.MorphingSupport;
import org.eclipse.wb.internal.core.utils.IAdaptable;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.layout.group.model.GroupLayoutCodeSupport;
import org.eclipse.wb.internal.swing.java6.model.GroupLayoutInfo2;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.support.SwingLayoutCodeGenerator;

public final class SwingGroupLayoutCodeSupport
extends GroupLayoutCodeSupport
implements LayoutConstants {
    private boolean m_isOldLayout;
    private GroupLayoutInfo2 m_layout;

    public SwingGroupLayoutCodeSupport(GroupLayoutInfo2 layout) {
        super((IAdaptable)layout);
        Expression node;
        this.m_layout = layout;
        CreationSupport creationSupport = layout.getCreationSupport();
        this.m_isOldLayout = creationSupport instanceof IImplicitCreationSupport ? "org.jdesktop.layout.GroupLayout".equals(layout.getDescription().getComponentClass().getName()) : (creationSupport.getNode() instanceof Expression ? ((node = (Expression)creationSupport.getNode()) != null ? AstNodeUtils.isSuccessorOf((Expression)node, (String)"org.jdesktop.layout.GroupLayout") : false) : false);
        this.initialize(this.m_isOldLayout);
        if (this.m_isOldLayout) {
            this.m_layout.addBroadcastListener(new JavaEventListener(){

                public void replaceChildAfter(JavaInfo parent, JavaInfo oldChild, JavaInfo newChild) throws Exception {
                    if (oldChild == SwingGroupLayoutCodeSupport.this.m_layout) {
                        SwingGroupLayoutCodeSupport.this.m_layout = (GroupLayoutInfo2)newChild;
                    }
                }
            });
        }
    }

    private void initialize(boolean old) {
        if (!old) {
            this.GROUP_LAYOUT_CLASS_NAME = "javax.swing.GroupLayout";
            this.ID_ADD_GAP = "addGap";
            this.ID_ADD_COMPONENT = "addComponent";
            this.ID_ADD_GROUP = "addGroup";
            this.SIGNATURE_LINK_SIZE = "linkSize(java.awt.Component[])";
            this.SIGNATURE_LINK_SIZE_AXIS = "linkSize(int,java.awt.Component[])";
        } else {
            this.GROUP_LAYOUT_CLASS_NAME = "org.jdesktop.layout.GroupLayout";
            this.ID_ADD_GAP = "add";
            this.ID_ADD_COMPONENT = "add";
            this.ID_ADD_GROUP = "add";
            this.SIGNATURE_LINK_SIZE = "linkSize(java.awt.Component[])";
            this.SIGNATURE_LINK_SIZE_AXIS = "linkSize(java.awt.Component[],int)";
        }
        this.GROUP_LAYOUT_GROUP_CLASS_NAME = String.valueOf(this.GROUP_LAYOUT_CLASS_NAME) + ".Group";
        this.SIGNATURE_SET_HORIZONTAL_GROUP = "setHorizontalGroup(" + this.GROUP_LAYOUT_GROUP_CLASS_NAME + ")";
        this.SIGNATURE_SET_VERTICAL_GROUP = "setVerticalGroup(" + this.GROUP_LAYOUT_GROUP_CLASS_NAME + ")";
    }

    protected final String prepareLayoutCode(List<AbstractComponentInfo> components) throws Exception {
        if (this.m_isOldLayout) {
            this.initialize(!this.m_isOldLayout);
            this.convertLayout();
            this.m_isOldLayout = false;
        }
        SwingLayoutCodeGenerator.ComponentInfo[] infos = new SwingLayoutCodeGenerator.ComponentInfo[components.size()];
        int i = 0;
        for (AbstractComponentInfo abstractComponent : components) {
            ComponentInfo component = (ComponentInfo)abstractComponent;
            SwingLayoutCodeGenerator.ComponentInfo info = new SwingLayoutCodeGenerator.ComponentInfo();
            info.id = ObjectInfoUtils.getId((ObjectInfo)component);
            info.variableName = "__wbpId:" + info.id;
            info.clazz = component.getDescription().getComponentClass();
            Property minProp = component.getPropertyByTitle("minimumSize");
            Property prefProp = component.getPropertyByTitle("preferredSize");
            Property maxProp = component.getPropertyByTitle("maximumSize");
            info.sizingChanged = minProp != null && minProp.isModified() || prefProp != null && prefProp.isModified() || maxProp != null && maxProp.isModified();
            Component componentObject = component.getComponent();
            info.minSize = componentObject != null ? componentObject.getMinimumSize() : new Dimension();
            infos[i++] = info;
        }
        String contVarName = this.getLayoutReference();
        StringWriter stringWriter = new StringWriter();
        SwingLayoutCodeGenerator swingGenerator = new SwingLayoutCodeGenerator(this.getLayout().getLayoutModel());
        swingGenerator.generateContainerLayout((Writer)stringWriter, this.getRootComponent(), contVarName, infos, false);
        return stringWriter.toString();
    }

    protected void checkComponent(AbstractComponentInfo component, int dimension) {
        if (JTextField.class.isAssignableFrom(component.getDescription().getComponentClass()) && dimension == 0) {
            LayoutInterval interval = this.getLayoutModel().getLayoutComponent(ObjectInfoUtils.getId((ObjectInfo)component)).getLayoutInterval(dimension);
            interval.setSizes(-1, -1, -1);
        }
    }

    protected void setGroupAlignment(LayoutInterval group, Expression arg) {
        if (!this.m_isOldLayout) {
            GroupLayout.Alignment alignment = (GroupLayout.Alignment)((Object)JavaInfoEvaluationHelper.getValue((Expression)arg));
            group.setGroupAlignment(alignment.ordinal());
        } else {
            Number alignment = (Number)JavaInfoEvaluationHelper.getValue((Expression)arg);
            group.setGroupAlignment(this.convertOldAlignment(alignment.intValue()));
        }
    }

    protected void setAlignment(LayoutInterval interval, Expression arg) {
        if (!this.m_isOldLayout) {
            GroupLayout.Alignment alignment = (GroupLayout.Alignment)((Object)JavaInfoEvaluationHelper.getValue((Expression)arg));
            interval.setAlignment(alignment.ordinal());
        } else {
            Number alignment = (Number)JavaInfoEvaluationHelper.getValue((Expression)arg);
            interval.setAlignment(this.convertOldAlignment(alignment.intValue()));
        }
    }

    protected void setPaddingType(LayoutInterval gap, Expression arg) {
        if (!this.m_isOldLayout) {
            LayoutStyle.ComponentPlacement placement = (LayoutStyle.ComponentPlacement)((Object)JavaInfoEvaluationHelper.getValue((Expression)arg));
            gap.setPaddingType(this.convertPadding(placement));
        } else {
            Number placement = (Number)JavaInfoEvaluationHelper.getValue((Expression)arg);
            gap.setPaddingType(this.convertOldPadding(placement.intValue()));
        }
    }

    protected boolean isComponent(Expression arg) {
        return AstNodeUtils.isSuccessorOf((Expression)arg, Component.class);
    }

    private LayoutConstants.PaddingType convertPadding(LayoutStyle.ComponentPlacement value) {
        switch (value) {
            case RELATED: {
                return LayoutConstants.PaddingType.RELATED;
            }
            case UNRELATED: {
                return LayoutConstants.PaddingType.UNRELATED;
            }
            case INDENT: {
                return LayoutConstants.PaddingType.INDENT;
            }
        }
        return LayoutConstants.PaddingType.SEPARATE;
    }

    private void convertLayout() throws Exception {
        Class<?> componentClass = EditorState.get((AstEditor)this.m_layout.getEditor()).getEditorLoader().loadClass("javax.swing.GroupLayout");
        ComponentDescription layoutDescription = ComponentDescriptionHelper.getDescription((AstEditor)this.m_layout.getEditor(), componentClass);
        try {
            layoutDescription.putTag("FLAG_IS_MORPHING", "true");
            MorphingTargetDescription target = new MorphingTargetDescription(componentClass, null);
            MorphingSupport.morph((String)"java.awt.Component", (JavaInfo)this.m_layout, (MorphingTargetDescription)target);
        }
        finally {
            layoutDescription.putTag("FLAG_IS_MORPHING", "false");
        }
    }

    protected int convertDimension(int dimension) {
        if (this.m_isOldLayout) {
            if (dimension == 1) {
                return 0;
            }
            if (dimension == 2) {
                return 1;
            }
        }
        return super.convertDimension(dimension);
    }

    private int convertOldAlignment(int value) {
        switch (value) {
            case 4: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return -1;
    }

    private LayoutConstants.PaddingType convertOldPadding(int value) {
        switch (value) {
            case 0: {
                return LayoutConstants.PaddingType.RELATED;
            }
            case 1: {
                return LayoutConstants.PaddingType.UNRELATED;
            }
            case 2: {
                return LayoutConstants.PaddingType.INDENT;
            }
        }
        return LayoutConstants.PaddingType.SEPARATE;
    }
}

