/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.xwt.tools.ui.designer.editor.model.BuilderContext;
import org.eclipse.xwt.tools.ui.designer.editor.model.Synchronizer;
import org.eclipse.xwt.tools.ui.designer.editor.model.XWTModelBuilder;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ModelAdapter
extends EContentAdapter {
    private BuilderContext fContext;
    private ReverseJob reverseJob;

    public ModelAdapter(BuilderContext mapper) {
        this.fContext = mapper;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.isTouch()) {
            return;
        }
        Synchronizer synch = this.fContext.getSynchronizer();
        XWTModelBuilder modelBuilder = this.fContext.getModelBuilder();
        modelBuilder.dispatchEvent(notification);
        if (synch.isFree()) {
            this.reverse(notification);
        }
    }

    private void reverse(Notification msg) {
        if (this.reverseJob == null) {
            this.reverseJob = new ReverseJob();
        }
        this.reverseJob.reverse(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToUpdateText(Notification msg) {
        Synchronizer synch;
        Synchronizer synchronizer = synch = this.fContext.getSynchronizer();
        synchronized (synchronizer) {
            synch.setEventType(Synchronizer.EventType.ModelEvent);
            Object notifier = msg.getNotifier();
            Object oldValue = msg.getOldValue();
            Object newValue = msg.getNewValue();
            if (oldValue != null && oldValue.equals(newValue)) {
                return;
            }
            IDOMNode textNode = this.fContext.getTextNode(notifier);
            IDOMNode oldNode = this.fContext.getTextNode(oldValue);
            IDOMNode newNode = this.fContext.getTextNode(newValue);
            int eventType = msg.getEventType();
            switch (eventType) {
                case 3: {
                    if (textNode == null && notifier instanceof EObject) {
                        EObject eContainer = ((EObject)notifier).eContainer();
                        IDOMNode superParent = this.fContext.getTextNode(eContainer);
                        if (superParent != null) {
                            if (notifier instanceof XamlAttribute) {
                                this.reverseAttr(superParent, (XamlAttribute)notifier);
                            } else if (notifier instanceof XamlElement) {
                                this.reverseNode(superParent, (XamlElement)newValue);
                            }
                        }
                        textNode = this.fContext.getTextNode(notifier);
                    }
                    if (textNode == null || !(textNode instanceof IDOMElement) && !(textNode instanceof IDOMAttr)) break;
                    if (notifier instanceof XamlAttribute && textNode instanceof IDOMAttr && newValue instanceof XamlElement) {
                        this.validatePrefix((XamlNode)((XamlElement)newValue));
                        String flatValue = ((XamlElement)newValue).getFlatValue();
                        if (flatValue == null) {
                            flatValue = "";
                        }
                        ((IDOMAttr)textNode).setValue("{" + flatValue + "}");
                        break;
                    }
                    if (newValue instanceof XamlAttribute) {
                        this.reverseAttr(textNode, (XamlAttribute)newValue);
                        break;
                    }
                    if (!(newValue instanceof XamlElement)) break;
                    this.reverseNode(textNode, (XamlElement)newValue);
                    break;
                }
                case 5: {
                    System.err.println("ADD_MANY");
                    break;
                }
                case 7: {
                    int oldPos = (Integer)oldValue;
                    int newPos = msg.getPosition();
                    IDOMNode parentNode = textNode;
                    IDOMNode moveable = newNode;
                    if (parentNode == null || moveable == null || parentNode != moveable.getParentNode()) break;
                    List<IDOMElement> eles = this.fContext.getChildNodes(parentNode);
                    int offset = newPos - oldPos;
                    int oldIndex = eles.indexOf(moveable);
                    int newIndex = offset > 0 ? oldIndex + offset + 1 : oldIndex + offset;
                    Node nextSibling = moveable.getNextSibling();
                    parentNode.removeChild((Node)moveable);
                    if (nextSibling instanceof Text) {
                        parentNode.removeChild(nextSibling);
                    }
                    if (newIndex >= 0 && newIndex <= eles.size() - 1) {
                        IDOMElement insert = eles.get(newIndex);
                        parentNode.insertBefore((Node)moveable, (Node)insert);
                        break;
                    }
                    parentNode.appendChild((Node)moveable);
                    break;
                }
                case 4: {
                    if (textNode == null) break;
                    if (oldNode instanceof IDOMElement) {
                        NodeList nodelist = textNode.getChildNodes();
                        int i = 0;
                        while (i < nodelist.getLength()) {
                            if (nodelist.item(i) == oldNode) {
                                textNode.removeChild((Node)oldNode);
                            }
                            ++i;
                        }
                    } else if (textNode instanceof IDOMElement && oldNode instanceof IDOMAttr && this.fContext.contains((Node)textNode, (Attr)oldNode)) {
                        ((IDOMElement)textNode).removeAttributeNode((Attr)oldNode);
                    }
                    this.fContext.remove(oldNode);
                    break;
                }
                case 6: {
                    System.err.println("REMOVE_MANY");
                    break;
                }
                case 1: 
                case 2: {
                    if (textNode == null) break;
                    if (textNode instanceof Attr) {
                        Attr attr;
                        String value = newValue == null ? "" : newValue.toString();
                        if (value.equals((attr = (Attr)textNode).getNodeValue())) break;
                        attr.setNodeValue(value);
                        break;
                    }
                    if (newValue == null || oldValue == null || !oldValue.equals(this.fContext.getContent(textNode))) break;
                    this.reverseContent(textNode, newValue.toString());
                }
            }
            synch.setFree();
        }
    }

    protected void reverseAttr(IDOMNode parent, XamlAttribute model) {
        String flatValue;
        IDOMDocument textDocument = this.fContext.getTextRoot();
        this.validatePrefix((XamlNode)model);
        String localName = parent.getLocalName();
        String value = model.getValue();
        String name = model.getName();
        if (value == null && model.isUseFlatValue() && (flatValue = model.getFlatValue()) != null && !"".equals(flatValue)) {
            value = "{" + flatValue + "}";
        }
        if (value != null && parent instanceof IDOMElement) {
            IDOMAttr attr = (IDOMAttr)textDocument.createAttribute(name);
            attr.setNodeValue(value);
            attr.setPrefix(model.getPrefix());
            ((IDOMElement)parent).setAttributeNode((Attr)attr);
            this.fContext.map((XamlNode)model, (IDOMNode)attr);
        } else {
            String childName = String.valueOf(localName) + "." + name;
            while (localName != null && localName.indexOf(".") != -1) {
                parent = (IDOMElement)parent.getParentNode();
                localName = parent.getLocalName();
            }
            EList childNodes = model.getChildNodes();
            EList attributes = model.getAttributes();
            if (!attributes.isEmpty()) {
                for (XamlAttribute attr : attributes) {
                    IDOMElement node;
                    if (attr.getValue() != null) {
                        node = (IDOMElement)textDocument.createElement(childName);
                        this.reverseAttr((IDOMNode)node, attr);
                        parent.appendChild((Node)node);
                        this.fContext.map((XamlNode)model, (IDOMNode)node);
                        continue;
                    }
                    node = (IDOMElement)textDocument.createElement(childName);
                    EList childNodes2 = attr.getChildNodes();
                    for (XamlElement child : childNodes2) {
                        this.reverseNode((IDOMNode)node, child);
                    }
                    parent.appendChild((Node)node);
                    this.fContext.map((XamlNode)model, (IDOMNode)node);
                }
            } else if (!childNodes.isEmpty()) {
                IDOMElement node = (IDOMElement)textDocument.createElement(childName);
                for (XamlElement child : childNodes) {
                    this.reverseNode((IDOMNode)node, child);
                }
                parent.appendChild((Node)node);
                this.fContext.map((XamlNode)model, (IDOMNode)node);
            } else {
                IDOMElement node = (IDOMElement)textDocument.createElement(childName);
                parent.appendChild((Node)node);
                this.fContext.map((XamlNode)model, (IDOMNode)node);
            }
        }
    }

    private String validatePrefix(XamlNode node) {
        Element root;
        Attr prefixNode;
        IDOMDocument textDocument = this.fContext.getTextRoot();
        XamlDocument modelRoot = this.fContext.getModelRoot();
        String prefix = node.getPrefix();
        String namespace = node.getNamespace();
        if (prefix == null && namespace != null) {
            prefix = this.fContext.getPrefix(namespace);
        }
        if (prefix != null && !prefix.equals(node.getPrefix()) || prefix == null && node.getPrefix() != null) {
            node.setPrefix(prefix);
        }
        if (prefix != null && (prefixNode = (root = textDocument.getDocumentElement()).getAttributeNode(prefix)) == null) {
            root.setAttribute("xmlns:" + prefix, namespace);
            modelRoot.addDeclaredNamespace(prefix, namespace);
        }
        for (XamlAttribute attr : node.getAttributes()) {
            this.validatePrefix((XamlNode)attr);
        }
        for (XamlElement child : node.getChildNodes()) {
            this.validatePrefix((XamlNode)child);
        }
        return prefix;
    }

    protected void reverseNode(IDOMNode parent, XamlElement element) {
        String name = element.getName();
        IDOMDocument textDocument = this.fContext.getTextRoot();
        IDOMElement node = (IDOMElement)textDocument.createElement(name);
        EList attributes = element.getAttributes();
        EList childnodes = element.getChildNodes();
        for (XamlAttribute attribute : attributes) {
            this.reverseAttr((IDOMNode)node, attribute);
        }
        for (XamlElement child : childnodes) {
            this.reverseNode((IDOMNode)node, child);
        }
        String prefix = this.validatePrefix((XamlNode)element);
        if (prefix != null) {
            node.setPrefix(prefix);
        }
        XamlNode next = null;
        XamlNode container = (XamlNode)element.eContainer();
        if (container != null) {
            int i = container.getChildNodes().indexOf((Object)element);
            try {
                next = (XamlNode)container.getChildNodes().get(i + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (next != null) {
            IDOMNode nextNode = this.fContext.getTextNode(next);
            parent.insertBefore((Node)node, (Node)nextNode);
        } else {
            parent.appendChild((Node)node);
        }
        String value = element.getValue();
        if (value != null) {
            this.reverseContent((IDOMNode)node, value);
        }
        this.fContext.map((XamlNode)element, (IDOMNode)node);
    }

    protected void reverseContent(IDOMNode node, String value) {
        String content = this.fContext.getContent(node);
        if (value == null && content == null || value != null && value.equals(content)) {
            return;
        }
        String string = value = value == null ? "" : value;
        if (content != null) {
            List<Text> contentNodes = this.fContext.getContentNodes(node);
            for (Text text : contentNodes) {
                String nodeValue = text.getNodeValue();
                if (nodeValue == null || this.fContext.filter(nodeValue).length() == 0) continue;
                text.setData(value);
            }
        } else {
            IDOMDocument textDocument = this.fContext.getTextRoot();
            Text textNode = textDocument.createTextNode(value == null ? "" : value);
            node.appendChild((Node)textNode);
        }
    }

    class ReverseJob
    extends Job {
        private List<Notification> reverseJobs;
        private long timestamp;

        public ReverseJob() {
            super("Reverse");
            this.timestamp = -1L;
            this.setPriority(20);
            this.setSystem(true);
            ISchedulingRule rule = new ISchedulingRule(){

                public boolean isConflicting(ISchedulingRule rule) {
                    return this.getClass() == rule.getClass();
                }

                public boolean contains(ISchedulingRule rule) {
                    return this.getClass() == rule.getClass();
                }
            };
            this.setRule(rule);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ArrayList<Notification> jobs = new ArrayList<Notification>(this.reverseJobs);
            for (Notification event : jobs) {
                ModelAdapter.this.tryToUpdateText(event);
            }
            List<Notification> list = this.reverseJobs;
            synchronized (list) {
                this.reverseJobs.removeAll(jobs);
                if (!this.reverseJobs.isEmpty()) {
                    this.schedule(1000L);
                }
            }
            this.timestamp = -1L;
            return Status.OK_STATUS;
        }

        public void reverse(Notification event) {
            if (this.reverseJobs == null) {
                this.reverseJobs = new ArrayList<Notification>();
            }
            this.reverseJobs.add(event);
            if (this.timestamp == -1L) {
                this.schedule(1000L);
            }
            this.timestamp = System.currentTimeMillis();
        }
    }
}

