/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.outline.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.xwt.tools.ui.palette.Entry;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public abstract class MoveCommand
extends Command {
    private IStructuredSelection source;
    private Object target;
    private Command command;
    private int operation;

    public MoveCommand(IStructuredSelection source, Object target, int operation) {
        this.setSource(source);
        this.setTarget(target);
        this.setOperation(operation);
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    protected boolean isMove() {
        return this.operation == 2;
    }

    public boolean canExecute() {
        boolean state;
        boolean bl = state = this.source != null && this.target != null && this.target instanceof XamlNode;
        if (!state) {
            return false;
        }
        IStructuredSelection sourceNodes = this.getSource();
        XamlNode parent = null;
        for (Object element : sourceNodes) {
            XamlNode sourceNode = null;
            if (element instanceof Entry) continue;
            if (!(element instanceof XamlNode)) {
                return false;
            }
            sourceNode = (XamlNode)element;
            XamlNode sourceParent = sourceNode.getParent();
            if (sourceParent == null) {
                return false;
            }
            if (parent == null) {
                parent = sourceParent;
                continue;
            }
            if (parent == sourceParent) continue;
            return false;
        }
        return !this.isMove() || sourceNodes.size() != 1 || sourceNodes.getFirstElement() != this.target;
    }

    public void setSource(IStructuredSelection source) {
        this.source = source;
    }

    public IStructuredSelection getSource() {
        return this.source;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public XamlNode getTarget() {
        return (XamlNode)this.target;
    }

    public final void execute() {
        CompoundCommand cmd = new CompoundCommand();
        this.collectCommands(cmd);
        this.command = cmd.unwrap();
        if (this.command.canExecute()) {
            this.command.execute();
        }
    }

    public boolean canUndo() {
        return this.command != null && this.command.canUndo();
    }

    public void undo() {
        this.command.undo();
    }

    protected abstract void collectCommands(CompoundCommand var1);
}

