/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.layouts.pages;

import java.lang.reflect.Field;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.tools.ui.designer.commands.ResizeCommand;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutDataType;
import org.eclipse.xwt.tools.ui.designer.layouts.control.FieldEditor;
import org.eclipse.xwt.tools.ui.designer.layouts.control.FieldEditorEvent;
import org.eclipse.xwt.tools.ui.designer.layouts.control.SpinnerFieldEditor;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.LayoutDataAssistantPage;
import org.eclipse.xwt.tools.ui.designer.model.RefreshAdapter;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.xwt.tools.ui.designer.resources.Messages;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class GridDataAssistantPage
extends LayoutDataAssistantPage {
    public GridDataAssistantPage() {
        super(LayoutDataType.GridData);
    }

    public Composite createControl(Composite parent) {
        Composite composite = this.createComposite(parent);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        composite.setLayout((Layout)grid);
        this.createAlignmentArea(composite);
        this.createHintsAndSpanningArea(composite);
        this.createMinimumArea(composite);
        this.createIndentsArea(composite);
        return composite;
    }

    private void createAlignmentArea(Composite parent) {
        Group aligmentGroup = this.createGroup(parent, Messages.GridDataAssistantPage_ALIGNS_GROUP_LABEL, 2);
        Group horizontalGroup = this.createGroup((Composite)aligmentGroup, Messages.GridDataAssistantPage_HORIZONTAL_GROUP_LABEL, 1);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        horizontalGroup.setLayoutData((Object)gd);
        String[][] hAlignRadios = new String[][]{{"Left", "SWT.LEFT"}, {"Center", "GRIDDATA.CENTER"}, {"Right", "SWT.RIGHT"}, {"Fill", "SWT.FILL"}};
        this.createRadio((Composite)horizontalGroup, null, "horizontalAlignment", hAlignRadios);
        this.createCheckBox((Composite)horizontalGroup, "grabExcessHorizontalSpace", Messages.GridDataAssistantPage_H_GRAB_LABEL);
        Group verticalGroup = this.createGroup((Composite)aligmentGroup, Messages.GridDataAssistantPage_VERTICAL_GROUP_LABEL, 1);
        gd = new GridData();
        gd.verticalAlignment = 4;
        verticalGroup.setLayoutData((Object)gd);
        String[][] vAlignRadios = new String[][]{{"Top", "SWT.TOP"}, {"Center", "GRIDDATA.CENTER"}, {"Bottom", "SWT.BOTTOM"}, {"Fill", "SWT.FILL"}};
        this.createRadio((Composite)verticalGroup, null, Messages.GridDataAssistantPage_V_ALIGN_LABEL, vAlignRadios);
        this.createCheckBox((Composite)verticalGroup, "grabExcessVerticalSpace", Messages.GridDataAssistantPage_V_GRAB_LABEL);
    }

    private void createHintsAndSpanningArea(Composite parent) {
        Composite composite = this.createComposite(parent);
        GridLayout grid = new GridLayout();
        grid.horizontalSpacing = 0;
        grid.marginWidth = 0;
        grid.marginHeight = 0;
        composite.setLayout((Layout)grid);
        Group hintsGroup = this.createGroup(composite, Messages.GridDataAssistantPage_HINTS_GROUP_NAME, 2);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        hintsGroup.setLayoutData((Object)gd);
        SpinnerFieldEditor widthSpinner = new SpinnerFieldEditor("widthHint", Messages.GridDataAssistantPage_WIDTH_LABEL, (Composite)hintsGroup){

            @Override
            public void apply(Object source) {
                if (!this.isValid() || source == null) {
                    return;
                }
                try {
                    Field field = source.getClass().getField(this.fieldName);
                    Object value = field.get(source);
                    if (-1 == (Integer)value) {
                        value = GridDataAssistantPage.this.getHintValue("width");
                    }
                    this.doUpdate(value == null ? "" : value.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.addEditor(widthSpinner);
        SpinnerFieldEditor heightSpinner = new SpinnerFieldEditor("heightHint", Messages.GridDataAssistantPage_HEIGHT_LABEL, (Composite)hintsGroup){

            @Override
            public void apply(Object source) {
                if (!this.isValid() || source == null) {
                    return;
                }
                try {
                    Field field = source.getClass().getField(this.fieldName);
                    Object value = field.get(source);
                    if (-1 == (Integer)value) {
                        value = GridDataAssistantPage.this.getHintValue("height");
                    }
                    this.doUpdate(value == null ? "" : value.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.addEditor(heightSpinner);
        Group spanningGroup = this.createGroup(composite, Messages.GridDataAssistantPage_SPANNING_GROUP_LABEL, 2);
        spanningGroup.setText("Spanning");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        spanningGroup.setLayoutData((Object)gd);
        this.createSpinner((Composite)spanningGroup, "horizontalSpan", Messages.GridDataAssistantPage_COLUMN_SPAN_LABEL);
        this.createSpinner((Composite)spanningGroup, "verticalSpan", Messages.GridDataAssistantPage_ROW_SPAN_LABEL);
    }

    @Override
    protected Command computeCommand(FieldEditorEvent event) {
        String field = event.field;
        if ("widthHint".equals(field)) {
            int oldIntValue = Integer.parseInt(event.oldValue.trim());
            int newIntValue = Integer.parseInt(event.newVlaue.trim());
            Dimension growth = new Dimension(newIntValue - oldIntValue, 0);
            return new ResizeCommand(this.getEditPart(), growth);
        }
        if ("heightHint".equals(field)) {
            int oldIntValue = Integer.parseInt(event.oldValue.trim());
            int newIntValue = Integer.parseInt(event.newVlaue.trim());
            Dimension growth = new Dimension(0, newIntValue - oldIntValue);
            return new ResizeCommand(this.getEditPart(), growth);
        }
        return super.computeCommand(event);
    }

    @Override
    protected void setUpRefresher(FieldEditor editor) {
        super.setUpRefresher(editor);
        String fieldName = editor.getFieldName();
        final FieldEditor forRefresh = editor;
        XamlNode model = this.getModel();
        if (model == null) {
            return;
        }
        if ("widthHint".equals(fieldName)) {
            this.getRefreshers(editor).add(new RefreshAdapter(model, "width"){

                @Override
                protected void performRefresh(Notification msg) {
                    forRefresh.apply(GridDataAssistantPage.this.getAssistant());
                }
            });
        } else if ("heightHint".equals(fieldName)) {
            this.getRefreshers(editor).add(new RefreshAdapter(model, "height"){

                @Override
                protected void performRefresh(Notification msg) {
                    forRefresh.apply(GridDataAssistantPage.this.getAssistant());
                }
            });
        }
    }

    public int getHintValue(String hint) {
        EditPart editPart = this.getEditPart();
        if (editPart == null || !(editPart instanceof WidgetEditPart)) {
            return -1;
        }
        Widget widget = ((WidgetEditPart)editPart).getWidget();
        if (widget == null || widget.isDisposed()) {
            return -1;
        }
        try {
            IProperty prop;
            IMetaclass metaclass = XWT.getMetaclass((Object)widget);
            if (metaclass != null && (prop = metaclass.findProperty(hint)) != null) {
                return (Integer)prop.getValue((Object)widget);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private void createMinimumArea(Composite parent) {
        Composite composite = this.createComposite(parent);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        composite.setLayout((Layout)grid);
        Group minimumGroup = this.createGroup(composite, Messages.GridDataAssistantPage_MINIMUM_GROUP_LABEL, 2);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        minimumGroup.setLayoutData((Object)gd);
        this.createSpinner((Composite)minimumGroup, "minimumWidth", Messages.GridDataAssistantPage_MIN_WIDTH_LABEL);
        this.createSpinner((Composite)minimumGroup, "minimumHeight", Messages.GridDataAssistantPage_MIN_HEIGHT_LABEL);
        this.createCheckBox(composite, "exclude", Messages.GridDataAssistantPage_EXCLUDE_LABEL);
    }

    private void createIndentsArea(Composite parent) {
        Group indentsGroup = this.createGroup(parent, Messages.GridDataAssistantPage_INDENTS_GROUP_LABEL, 2);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        indentsGroup.setLayoutData((Object)gd);
        this.createSpinner((Composite)indentsGroup, "horizontalIndent", Messages.GridDataAssistantPage_H_INDENT_LABEL);
        this.createSpinner((Composite)indentsGroup, "verticalIndent", Messages.GridDataAssistantPage_V_INDENT_LABEL);
    }

    @Override
    protected Object getAssistant() {
        Object assistant = super.getAssistant();
        if (assistant == null) {
            assistant = new GridData();
        }
        return assistant;
    }
}

