/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizationAction;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.SnippetsPluginImageHelper;
import org.eclipse.wst.common.snippets.internal.model.SnippetManager;
import org.eclipse.wst.common.snippets.internal.palette.ModelFactoryForUser;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.palette.UserModelDumper;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsCustomizer;
import org.osgi.framework.Bundle;

public class SnippetCustomizerDialog
extends PaletteCustomizerDialog {
    private TreeViewer fTreeviewer = null;

    protected void handleDelete() {
        this.clearProblem();
        super.handleDelete();
    }

    public SnippetCustomizerDialog(Shell shell, PaletteCustomizer customizer, PaletteRoot root) {
        super(shell, customizer, root);
    }

    protected List createOutlineActions() {
        List actions = super.createOutlineActions();
        actions.add(new ImportAction());
        actions.add(new ExportAction());
        return actions;
    }

    protected TreeViewer createOutlineTreeViewer(Composite composite) {
        this.fTreeviewer = super.createOutlineTreeViewer(composite);
        return this.fTreeviewer;
    }

    public int open() {
        this.save();
        return super.open();
    }

    static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[2048];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    void unzip(ZipFile zipFile, String path) throws FileNotFoundException, IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(String.valueOf(path) + File.separator + entry.getName());
            if (entry.isDirectory()) {
                file.mkdir();
                continue;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (entry.getName().toLowerCase().equals("snippets.xml")) continue;
            SnippetCustomizerDialog.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(file)));
        }
        zipFile.close();
    }

    private static class EXPORT_IMPORT_STRATEGY {
        static EXPORT_IMPORT_STRATEGY ARCHIVE = new EXPORT_IMPORT_STRATEGY();
        static EXPORT_IMPORT_STRATEGY XML = new EXPORT_IMPORT_STRATEGY();

        private EXPORT_IMPORT_STRATEGY() {
        }
    }

    private class ExportAction
    extends PaletteCustomizationAction {
        public ExportAction() {
            this.setEnabled(false);
            this.setText(SnippetsMessages.SnippetCustomizerDialog_1);
            this.setImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/export.gif"));
            this.setDisabledImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/export.gif"));
            this.setHoverImageDescriptor(SnippetsPluginImageHelper.getInstance().getImageDescriptor("icons/full/clcl16/export.gif"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.common.snippets.snip0020");
        }

        protected void handleExport() {
            SnippetPaletteDrawer exportCategory = (SnippetPaletteDrawer)SnippetCustomizerDialog.this.getSelectedPaletteEntry();
            EXPORT_IMPORT_STRATEGY strategy = this.exportStrategy(exportCategory);
            if (EXPORT_IMPORT_STRATEGY.ARCHIVE == strategy) {
                this.exportArchive(exportCategory);
            } else {
                this.exportXML(exportCategory);
            }
            SnippetCustomizerDialog.this.updateActions();
        }

        private EXPORT_IMPORT_STRATEGY exportStrategy(PaletteDrawer exportCategory) {
            List children = exportCategory.getChildren();
            int i = 0;
            while (i < children.size()) {
                ISnippetItem snippetItem = (ISnippetItem)children.get(i);
                File folder = new File(SnippetManager.getInstance().getStorageLocation(snippetItem.getId()).toOSString());
                if (folder.exists()) {
                    return EXPORT_IMPORT_STRATEGY.ARCHIVE;
                }
                ++i;
            }
            return EXPORT_IMPORT_STRATEGY.XML;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void exportArchive(SnippetPaletteDrawer exportCategory) {
            String filename = this.openFileDialog("*.zip");
            if (filename == null) return;
            ZipOutputStream outputStream = null;
            try {
                try {
                    SnippetDefinitions definitions = this.getCategory(exportCategory, filename);
                    outputStream = new ZipOutputStream(new FileOutputStream(filename));
                    ZipEntry descriptorFile = new ZipEntry("snippets.xml");
                    outputStream.putNextEntry(descriptorFile);
                    new UserModelDumper().write(definitions, outputStream);
                    ISnippetCategory existingCategory = definitions.getCategory(exportCategory.getId());
                    ISnippetItem[] items = existingCategory.getItems();
                    int i = 0;
                    while (i < items.length) {
                        File folder = new File(SnippetManager.getInstance().getStorageLocation(items[i].getId()).toOSString());
                        if (folder.exists()) {
                            this.addToZip(folder.getParentFile(), folder, outputStream);
                        }
                        ++i;
                    }
                    return;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    if (outputStream == null) return;
                    try {
                        outputStream.close();
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (outputStream == null) return;
                    try {
                        outputStream.close();
                        return;
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    return;
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void addToZip(File root, File folder, ZipOutputStream outputStream) throws IOException {
            File[] listedFiles = folder.listFiles();
            int i = 0;
            while (i < listedFiles.length) {
                if (listedFiles[i].isDirectory()) {
                    this.addToZip(root, listedFiles[i], outputStream);
                } else {
                    int count;
                    ZipEntry ze = new ZipEntry(listedFiles[i].getAbsolutePath().substring(root.getAbsolutePath().length() + 1));
                    outputStream.putNextEntry(ze);
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(listedFiles[i]), 1024);
                    byte[] data = new byte[1024];
                    while ((count = bis.read(data, 0, 1024)) != -1) {
                        outputStream.write(data, 0, count);
                    }
                    bis.close();
                }
                ++i;
            }
        }

        private void exportXML(SnippetPaletteDrawer exportCategory) {
            block13: {
                String filename = this.openFileDialog("*.xml");
                OutputStream outputStream = null;
                if (filename != null) {
                    try {
                        try {
                            SnippetDefinitions definitions = this.getCategory(exportCategory, filename);
                            outputStream = new FileOutputStream(filename);
                            new UserModelDumper().write(definitions, outputStream);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            if (outputStream == null) break block13;
                            try {
                                outputStream.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }

        private SnippetDefinitions getCategory(SnippetPaletteDrawer exportCategory, String fileName) {
            SnippetDefinitions definitions = ModelFactoryForUser.getInstance().load(fileName);
            ISnippetCategory existingCategory = definitions.getCategory(exportCategory.getId());
            if (existingCategory == null) {
                definitions.getCategories().add(exportCategory);
            } else {
                String title = SnippetsMessages.SnippetCustomizerDialog_2;
                String message = NLS.bind((String)SnippetsMessages.SnippetCustomizerDialog_4, (Object[])new String[]{existingCategory.getLabel()});
                boolean answer = MessageDialog.openConfirm((Shell)SnippetCustomizerDialog.this.getShell(), (String)title, (String)message);
                if (answer) {
                    definitions.getCategories().remove(existingCategory);
                    definitions.getCategories().add(exportCategory);
                }
            }
            return definitions;
        }

        private String openFileDialog(String extension) {
            FileDialog fileDialog = new FileDialog(SnippetCustomizerDialog.this.getShell(), 8192);
            fileDialog.setText(SnippetsMessages.Export_Snippets);
            fileDialog.setFileName("snippets" + extension.substring(1));
            String[] filterExtensions = new String[]{extension, "*.*"};
            fileDialog.setFilterExtensions(filterExtensions);
            String filename = fileDialog.open();
            return filename;
        }

        public void run() {
            this.handleExport();
        }

        public void update() {
            boolean enabled = false;
            PaletteEntry entry = SnippetCustomizerDialog.this.getSelectedPaletteEntry();
            if (entry != null && SnippetCustomizerDialog.this.getCustomizer() instanceof SnippetsCustomizer) {
                enabled = ((SnippetsCustomizer)SnippetCustomizerDialog.this.getCustomizer()).canExport(entry);
            }
            this.setEnabled(enabled);
        }
    }

    private class ImportAction
    extends PaletteCustomizationAction {
        public ImportAction() {
            this.setEnabled(false);
            this.setText(SnippetsMessages.SnippetCustomizerDialog_0);
            SnippetsPluginImageHelper pluginImageHelper = SnippetsPluginImageHelper.getInstance();
            this.setImageDescriptor(pluginImageHelper.getImageDescriptor("icons/full/elcl16/import.gif"));
            this.setDisabledImageDescriptor(pluginImageHelper.getImageDescriptor("icons/full/dlcl16/import.gif"));
            this.setHoverImageDescriptor(pluginImageHelper.getImageDescriptor("icons/full/clcl16/import.gif"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.common.snippets.snip0010");
        }

        protected void handleImport() {
            FileDialog fileDialog = new FileDialog(SnippetCustomizerDialog.this.getShell(), 4096);
            fileDialog.setText(SnippetsMessages.Import_Snippets);
            String[] filterExtensions = new String[]{"*.xml; *.zip", "*.*"};
            fileDialog.setFilterExtensions(filterExtensions);
            String filename = fileDialog.open();
            if (filename == null) {
                return;
            }
            try {
                if (filename.toLowerCase(Locale.US).endsWith(".zip")) {
                    ZipFile zip = new ZipFile(new File(filename));
                    ZipEntry entry = zip.getEntry("snippets.xml");
                    this.loadMetadata(zip.getInputStream(entry));
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.snippets");
                    SnippetCustomizerDialog.this.unzip(zip, Platform.getStateLocation((Bundle)bundle).toOSString());
                } else {
                    this.loadMetadata(new FileInputStream(filename));
                }
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }

        private void loadMetadata(InputStream fileInputStream) {
            if (fileInputStream != null) {
                SnippetDefinitions definitions = ModelFactoryForUser.getInstance().load(fileInputStream);
                List<ISnippetCategory> importCategories = definitions.getCategories();
                List<ISnippetCategory> currentCategories = SnippetManager.getInstance().getDefinitions().getCategories();
                PaletteEntry lastImportEntry = null;
                int i = 0;
                while (i < importCategories.size()) {
                    boolean found = false;
                    int j = 0;
                    while (j < currentCategories.size()) {
                        if (((PaletteEntry)currentCategories.get(j)).getId().compareToIgnoreCase(((PaletteEntry)importCategories.get(i)).getId()) == 0) {
                            String title = SnippetsMessages.SnippetCustomizerDialog_2;
                            String message = NLS.bind((String)SnippetsMessages.SnippetCustomizerDialog_3, (Object[])new String[]{((PaletteEntry)currentCategories.get(j)).getLabel()});
                            boolean answer = MessageDialog.openConfirm((Shell)SnippetCustomizerDialog.this.getShell(), (String)title, (String)message);
                            if (answer) {
                                SnippetManager.getInstance().getPaletteRoot().remove((PaletteEntry)currentCategories.get(j));
                                SnippetManager.getInstance().getPaletteRoot().add((PaletteEntry)importCategories.get(i));
                                lastImportEntry = (PaletteEntry)importCategories.get(i);
                            }
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        SnippetManager.getInstance().getPaletteRoot().add((PaletteEntry)importCategories.get(i));
                        lastImportEntry = (PaletteEntry)importCategories.get(i);
                    }
                    ++i;
                }
                if (lastImportEntry != null) {
                    SnippetCustomizerDialog.this.fTreeviewer.setSelection((ISelection)new StructuredSelection(lastImportEntry), true);
                }
                SnippetCustomizerDialog.this.updateActions();
            }
        }

        public void run() {
            this.handleImport();
        }

        public void update() {
            boolean enabled = false;
            PaletteEntry entry = SnippetCustomizerDialog.this.getSelectedPaletteEntry();
            if (entry != null && SnippetCustomizerDialog.this.getCustomizer() instanceof SnippetsCustomizer) {
                enabled = ((SnippetsCustomizer)SnippetCustomizerDialog.this.getCustomizer()).canImport(entry);
            }
            this.setEnabled(enabled);
        }
    }
}

