/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emf.resource.MappedXMIHelper;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class MappedComponentXMIHelper
extends MappedXMIHelper {
    public MappedComponentXMIHelper(XMLResource resource, Map prefixesToURIs) {
        super(resource, prefixesToURIs);
    }

    public URI resolve(URI relative, URI base) {
        URI resolved = null;
        resolved = !this.isMapped(relative) ? this.resolveURIFromComponent(relative, base) : relative;
        return resolved == null ? super.resolve(relative, base) : resolved;
    }

    private boolean isMapped(URI relative) {
        boolean isMapped = false;
        ResourceSet set = this.getResource().getResourceSet();
        if (set != null) {
            URI localresourceURI = relative;
            if (relative.hasFragment()) {
                localresourceURI = relative.trimFragment();
            }
            isMapped = !((URIConverterImpl.URIMap)set.getURIConverter().getURIMap()).getURI(localresourceURI).equals(localresourceURI);
        }
        return isMapped;
    }

    private URI resolveURIFromComponent(URI relative, URI base) {
        IVirtualComponent component = this.getComponent(base);
        if (component != null) {
            IPath resolvingPath;
            boolean hasFragment = relative.hasFragment();
            URI tmpURI = hasFragment ? relative.trimFragment() : relative;
            IVirtualFile virtualFile = component.getRootFolder().getFile((IPath)new Path(tmpURI.toString()));
            if (virtualFile != null && (resolvingPath = virtualFile.getWorkspaceRelativePath()) != null) {
                URI result = URI.createPlatformResourceURI((String)resolvingPath.toString());
                if (hasFragment) {
                    result = result.appendFragment(relative.fragment());
                }
                return result;
            }
        }
        return null;
    }

    private IVirtualComponent getComponent(URI base) {
        IVirtualResource[] virtualResources;
        IFile file;
        ResourceSet set = this.getResource().getResourceSet();
        if (set == null || set.getURIConverter() == null) {
            return null;
        }
        URI normalized = set.getURIConverter().normalize(base);
        if (WorkbenchResourceHelperBase.isPlatformResourceURI((URI)normalized) && (file = WorkbenchResourceHelper.getPlatformFile((URI)normalized)) != null && (virtualResources = ComponentCore.createResources((IResource)file)).length > 0) {
            return virtualResources[0].getComponent();
        }
        return null;
    }
}

