/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.parts;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.core.editor.IVisualFactory;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingInfo;
import org.eclipse.xwt.tools.ui.designer.databinding.DataContext;
import org.eclipse.xwt.tools.ui.designer.parts.BindingConnectionEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ColumnEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ControlEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.CoolBarEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.CoolItemEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.DataContextEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.DiagramEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ExpandBarEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ExpandItemEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ItemEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.LabelEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.MenuBarEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.MenuEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.MenuItemEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.SashFormEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ShellEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.TabFolderEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.TabItemEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ToolBarEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ToolItemEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ViewerEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.xwt.tools.ui.designer.utils.StyleHelper;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.palette.page.editparts.EditPartFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class XWTEditPartFactory
extends EditPartFactory {
    private IVisualFactory factory;

    public void setVisualFactory(IVisualFactory factory) {
        this.factory = factory;
    }

    public IVisualFactory getVisualFactory() {
        return this.factory;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof XamlDocument) {
            return new DiagramEditPart((XamlDocument)model);
        }
        if (model instanceof DataContext) {
            return new DataContextEditPart((DataContext)model);
        }
        if (model instanceof BindingInfo) {
            return new BindingConnectionEditPart((BindingInfo)model);
        }
        if (model instanceof XamlNode) {
            IMetaclass metaclass;
            XamlNode element = (XamlNode)model;
            Object visual = null;
            if (this.factory != null) {
                visual = this.factory.getVisual((EObject)element);
            }
            Class type = null;
            if (visual != null) {
                type = visual.getClass();
            } else if (element instanceof XamlElement && (metaclass = XWTUtility.getMetaclass((XamlNode)((XamlElement)model))) != null && metaclass.getType() != null) {
                type = metaclass.getType();
            }
            if (type == null) {
                throw new UnsupportedOperationException("Unsupport Type: " + model.toString());
            }
            if (Shell.class.isAssignableFrom(type)) {
                return new ShellEditPart((Shell)visual, element);
            }
            if (TabFolder.class.isAssignableFrom(type) || CTabFolder.class.isAssignableFrom(type)) {
                return new TabFolderEditPart((Composite)visual, element);
            }
            if (CoolBar.class.isAssignableFrom(type)) {
                return new CoolBarEditPart((CoolBar)visual, element);
            }
            if (ToolBar.class.isAssignableFrom(type)) {
                return new ToolBarEditPart((ToolBar)visual, element);
            }
            if (ExpandBar.class.isAssignableFrom(type)) {
                return new ExpandBarEditPart((ExpandBar)visual, element);
            }
            if (SashForm.class.isAssignableFrom(type)) {
                return new SashFormEditPart((SashForm)visual, element);
            }
            if (Composite.class.isAssignableFrom(type)) {
                return new CompositeEditPart((Composite)visual, element);
            }
            if (Label.class.isAssignableFrom(type)) {
                return new LabelEditPart((Label)visual, element);
            }
            if (Control.class.isAssignableFrom(type)) {
                return new ControlEditPart((Control)visual, element);
            }
            if (TabItem.class.isAssignableFrom(type) || CTabItem.class.isAssignableFrom(type)) {
                return new TabItemEditPart((Item)visual, element);
            }
            if (MenuItem.class.isAssignableFrom(type)) {
                return new MenuItemEditPart((MenuItem)visual, element);
            }
            if (CoolItem.class.isAssignableFrom(type)) {
                return new CoolItemEditPart((CoolItem)visual, element);
            }
            if (ToolItem.class.isAssignableFrom(type)) {
                return new ToolItemEditPart((ToolItem)visual, element);
            }
            if (ExpandItem.class.isAssignableFrom(type)) {
                return new ExpandItemEditPart((ExpandItem)visual, element);
            }
            if (TableColumn.class.isAssignableFrom(type) || TreeColumn.class.isAssignableFrom(type)) {
                return new ColumnEditPart((Item)visual, element);
            }
            if (Menu.class.isAssignableFrom(type)) {
                if (StyleHelper.checkStyle(element, 2)) {
                    return new MenuBarEditPart((Menu)visual, element);
                }
                return new MenuEditPart((Menu)visual, element);
            }
            if (Item.class.isAssignableFrom(type)) {
                return new ItemEditPart((Item)visual, element);
            }
            if (Widget.class.isAssignableFrom(type)) {
                return new WidgetEditPart((Widget)visual, element);
            }
            try {
                Class<?> jfaceViewer = Class.forName("org.eclipse.jface.viewers.Viewer");
                if (jfaceViewer.isAssignableFrom(type)) {
                    return new ViewerEditPart((Viewer)visual, element);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException("Unsupport Type: " + model.toString());
    }
}

