/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.xwt.tools.ui.designer.core.util.DisplayUtil;
import org.eclipse.xwt.tools.ui.designer.parts.figures.Expandable;

public class ExpandableEditPolicy
extends GraphicalEditPolicy
implements EditPartListener {
    private List<Object> listenedParts = new ArrayList<Object>();
    protected FocusListener focusListener = new FocusListener();

    public void activate() {
        super.activate();
        this.addFocusListener(this.getHost());
    }

    private void addFocusListener(EditPart part) {
        List childList;
        if (part == null) {
            return;
        }
        if (!this.listenedParts.contains(part)) {
            part.addEditPartListener((EditPartListener)this.focusListener);
            part.addEditPartListener((EditPartListener)this);
            this.listenedParts.add(part);
        }
        if ((childList = part.getChildren()) != null) {
            for (EditPart ep : childList) {
                this.addFocusListener(ep);
            }
        }
    }

    private void removeFocusListener(EditPart part) {
        List childList;
        if (part == null) {
            return;
        }
        if (this.listenedParts.remove(part)) {
            part.removeEditPartListener((EditPartListener)this.focusListener);
            part.removeEditPartListener((EditPartListener)this);
        }
        if ((childList = part.getChildren()) != null) {
            for (EditPart ep : childList) {
                this.removeFocusListener(ep);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        this.removeFocusListener(this.getHost());
        IFigure figure = this.getHostFigure();
        if (figure instanceof Expandable && this.getLayer() == figure.getParent()) {
            this.getLayer().remove(figure);
        }
    }

    public void expand() {
        IFigure figure = this.getHostFigure();
        if (figure instanceof Expandable && this.getLayer() != figure.getParent()) {
            this.getLayer().add(figure);
            ((Expandable)figure).expand();
        }
    }

    public IFigure getLayer() {
        return this.getLayer("Connection Layer");
    }

    public void collapse() {
        IFigure figure = this.getHostFigure();
        if (figure instanceof Expandable) {
            ((Expandable)figure).collapse();
        }
    }

    protected boolean shouldExpanded(EditPart part) {
        return part.getSelected() != 0;
    }

    public void childAdded(final EditPart child, int index) {
        IFigure figure;
        this.addFocusListener(child);
        if (child instanceof GraphicalEditPart && (figure = ((GraphicalEditPart)child).getFigure()) instanceof Expandable) {
            ((Expandable)figure).expand();
            this.getLayer().add(figure);
        }
        DisplayUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                child.getViewer().select(child);
                ExpandableEditPolicy.this.expand();
            }
        });
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
        IFigure figure;
        if (child instanceof GraphicalEditPart && (figure = ((GraphicalEditPart)child).getFigure()) instanceof Expandable && figure.getParent() == this.getLayer()) {
            ((Expandable)figure).collapse();
            this.getLayer().remove(figure);
        }
        this.removeFocusListener(child);
    }

    public void selectedStateChanged(EditPart editpart) {
    }

    private class FocusListener
    extends EditPartListener.Stub {
        private FocusListener() {
        }

        public void selectedStateChanged(EditPart part) {
            if (ExpandableEditPolicy.this.shouldExpanded(part)) {
                ExpandableEditPolicy.this.expand();
            } else {
                ExpandableEditPolicy.this.collapse();
            }
        }
    }
}

