// extras.h - Extras
// Copyright (C) 2007  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#pragma once

#include "../kshutdown.h"

#include <QFileInfo>
#include <QMenu>
#include <QPushButton>

class CommandAction;

class Extras final: public Action {
	friend class CommandAction;
public:
	virtual QString getStringOption() override;
	virtual void setStringOption(const QString &option) override;
	void initContainerWidget() override;
	virtual bool onAction() override;
	virtual bool onCommandLineOption() override;
	virtual void readConfig() override;
	static Extras *self() {
		if (!m_instance)
			m_instance = new Extras();

		return m_instance;
	}
	virtual void writeConfig() override;
private:
	Q_DISABLE_COPY(Extras)
	bool m_examplesCreated = false;
	inline static Extras *m_instance = nullptr;
	QMenu *m_menu = nullptr;
	QPushButton *m_menuButton;
	QString m_command = QString();
	explicit Extras();
	CommandAction *createCommandAction(const QFileInfo &fileInfo, const bool returnNull);
	QMenu *createMenu();
	void createMenu(QMenu *parentMenu, const QString &parentDir);
	QString getFilesDirectory();
	static QIcon readDesktopInfo(const QFileInfo &fileInfo, QString &text, QString &description);
	void setCommandAction(const CommandAction *command);

	// event handlers:
	void onModify();
	void onUpdateMenu();
};

class CommandAction final: private QAction {
	friend class Extras;
private:
	Q_DISABLE_COPY(CommandAction)
	QString m_command;
	explicit CommandAction(const QIcon &icon, const QString &text, QObject *parent, const QFileInfo &fileInfo, const QString &description);
};
