// preferences.h - Preferences Dialog
// Copyright (C) 2007  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#pragma once

#include "udialog.h"

#include <QCheckBox>
#include <QLineEdit>
#include <QListWidget>
#include <QPlainTextEdit>

class InfoWidget;
class PasswordPreferences;

class Preferences final: public UDialog {
public:
	inline static const int RESTART_PAGE_INDEX = 3;

	explicit Preferences(QWidget *parent, const int pageIndex);
	virtual ~Preferences() = default;
	static void showDialog(const int pageIndex = -1);
private:
	Q_DISABLE_COPY(Preferences)
	bool m_oldProgressBarVisible;
	InfoWidget *m_restartMessage;
	PasswordPreferences *m_passwordPreferences;
	QCheckBox *m_bootEntriesVisibleInMenu;
	QCheckBox *m_bootEntriesVisibleInWindow;
	QCheckBox *m_cancelDefault;
	QCheckBox *m_confirmAction;
	QCheckBox *m_countdownEnabled;
	QCheckBox *m_lockScreenBeforeHibernate;
	QCheckBox *m_noMinimizeToSystemTrayIcon;
	QCheckBox *m_progressBarEnabled;
	QCheckBox *m_systemTrayIconCustomColor;
	QCheckBox *m_systemTrayIconEnabled;
	QCheckBox *m_useThemeIconInSystemTray;
	QColor systemTrayIconActiveColor;
	QColor systemTrayIconNormalColor;
	QIcon m_fallbackIcon;
	#ifdef Q_OS_LINUX
	QLineEdit *m_lockCommand;
	QLineEdit *m_setBootEntryCommand;
	#endif // Q_OS_LINUX
	QList<QWidget *> m_pageListData = QList<QWidget *>();
	QListWidget *m_pageListWidget;
	QPlainTextEdit *m_bootEntries;
	QPushButton *m_systemTrayIconActiveColorButton;
	QPushButton *m_systemTrayIconNormalColorButton;
	QVBoxLayout *m_pageContainerLayout;
	QWidget *m_currentPageWidget = nullptr;
	static void addHeader(QVBoxLayout *layout, const QString &text);
	void addPage(QWidget *widget, const QString &text, const QString &iconName);
	void apply();
	//QWidget *createActionsWidget();
	QWidget *createGeneralWidget();
	QWidget *createRebootWidget();
	QWidget *createSystemTrayWidget();
	//QWidget *createTriggersWidget();
	void setCurrentPage(const int index);
	void showRestartMessage();
	void updateSystemTrayIconPreview();

	// event handlers:
	void onFinish(int result);
	void onProgressBarEnabled(bool enabled) const;
};
