// udialog.h - A dialog base
// Copyright (C) 2011  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#pragma once

#include <QDialog>
#include <QDialogButtonBox>
#include <QVBoxLayout>

class UDialog: public QDialog {
public:
	enum class WindowSize { FIXED, LARGE };

	explicit UDialog(QWidget *parent, const QString &windowTitle, const bool simple);
	virtual ~UDialog() = default;
	QPushButton *acceptButton() { return m_acceptButton; }
	QDialogButtonBox *buttonBox() { return m_dialogButtonBox; }
	QVBoxLayout *mainLayout() { return m_mainLayout; }
	QVBoxLayout *rootLayout() { return m_rootLayout; }

	void moveToCenterOfScreen();
	void setWindowSize(const WindowSize windowSize);

	// messages

	[[nodiscard]] static bool confirm(QWidget *parent, const QString &text);
	static void error(QWidget *parent, const QString &text);
	static void info(QWidget *parent, const QString &text);
	static void warning(QWidget *parent, const QString &text);

	// misc

	#ifdef KS_PURE_QT
	static void about(QWidget *parent);
	#endif // KS_PURE_QT
	static void largeWidget(QWidget *parent, QWidget *widget, const QString &windowTitle, const QList<QPushButton *> &actionButtonList);
	static void plainText(QWidget *parent, const QString &text, const QString &windowTitle);
	static void systemInfo(QWidget *parent);

private:
	Q_DISABLE_COPY(UDialog)
	QDialogButtonBox *m_dialogButtonBox;
	QPushButton *m_acceptButton;
	QVBoxLayout *m_mainLayout;
	QVBoxLayout *m_rootLayout;
};
