#ifndef _html_messagebox_
#define _html_messagebox_

/**
@file
Subclass of DIALOG_DISPLAY_HTML_TEXT_BASE, which is generated by wxFormBuilder.
*/

#include "../common/dialogs/dialog_display_info_HTML_base.h"

/** Implementing HTML_MESSAGE_BOX */
class HTML_MESSAGE_BOX : public DIALOG_DISPLAY_HTML_TEXT_BASE
{
protected:
    // Handlers for HTML_MESSAGE_BOX_BASE events.
    void OnCloseButtonClick( wxCommandEvent& event );

public:
    /** Constructor */
    HTML_MESSAGE_BOX( wxWindow* parent, const wxString & aTitle,
                       wxPoint aPos = wxDefaultPosition,
                       wxSize aSize = wxSize( 450,250 ) );

    /**
     * Function ListSet
     * Add a list of items.
     * @param aList = a string containing items. Items are separated by '\n'
     */
    void ListSet(const wxString &aList);
    /**
     * Function ListSet
     * Add a list of items.
     * @param aList = a wxArrayString containing items.
     */
    void ListSet(const wxArrayString &aList);

    void ListClear();
    /**
     * Function MessageSet
     * Add a message (in bold) to message list.
     * @param message = the message
     */
    void MessageSet(const wxString &message);

    /**
     * Function AddHTML_Text
     * Add a html text (without any change) to message list.
     * @param message = the text to add
     */
    void AddHTML_Text(const wxString &message);
};

#endif // _html_messagebox_
