/////////////////////////////////////////////////////////////////////////////
// Name:        dialog_netlist.cpp
// Purpose:     
// Author:      jean-pierre Charras
// Modified by: 
// Created:     26/02/2006 17:42:19
// RCS-ID:      
// Copyright:   License GNU
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 26/02/2006 17:42:19


// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "dialog_netlist.h"

////@begin XPM images
////@end XPM images

/*!
 * WinEDA_NetlistFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_NetlistFrame, wxDialog )

/*!
 * WinEDA_NetlistFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_NetlistFrame, wxDialog )

////@begin WinEDA_NetlistFrame event table entries
    EVT_BUTTON( ID_OPEN_NELIST, WinEDA_NetlistFrame::OnOpenNelistClick )

    EVT_BUTTON( ID_READ_NETLIST_FILE, WinEDA_NetlistFrame::OnReadNetlistFileClick )

    EVT_BUTTON( ID_TEST_NETLIST, WinEDA_NetlistFrame::OnTestNetlistClick )

    EVT_BUTTON( ID_COMPILE_RATSNEST, WinEDA_NetlistFrame::OnCompileRatsnestClick )

    EVT_BUTTON( wxID_CLOSE, WinEDA_NetlistFrame::OnCloseClick )

////@end WinEDA_NetlistFrame event table entries

END_EVENT_TABLE()

/*!
 * WinEDA_NetlistFrame constructors
 */

WinEDA_NetlistFrame::WinEDA_NetlistFrame( )
{
}

WinEDA_NetlistFrame::WinEDA_NetlistFrame( WinEDA_PcbFrame* parent, wxDC * DC, 
        wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	m_Parent = parent;
	m_DC = DC;
	/* Setup the NETLIST file name according to the board file name */
	NetNameBuffer = m_Parent->m_CurrentScreen->m_FileName;
	ChangeFileNameExt(NetNameBuffer, NetExtBuffer);

    Create(parent, id, caption, pos, size, style);

    wxString title = GetTitle() + NetNameBuffer;
	SetTitle(title);

}

/*!
 * WinEDA_NetlistFrame creator
 */

bool WinEDA_NetlistFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin WinEDA_NetlistFrame member initialisation
    m_Select_By_Timestamp = NULL;
    m_DeleteBadTracks = NULL;
    m_ChangeExistantModuleCtrl = NULL;
    m_DisplayWarningCtrl = NULL;
    m_MessageWindow = NULL;
////@end WinEDA_NetlistFrame member initialisation

////@begin WinEDA_NetlistFrame creation
    SetExtraStyle(GetExtraStyle()|wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    GetSizer()->Fit(this);
    GetSizer()->SetSizeHints(this);
    Centre();
////@end WinEDA_NetlistFrame creation
    return true;
}

/*!
 * Control creation for WinEDA_NetlistFrame
 */

void WinEDA_NetlistFrame::CreateControls()
{    
	SetFont(*g_DialogFont);
////@begin WinEDA_NetlistFrame content construction
    // Generated by DialogBlocks, 26/02/2006 18:24:19 (unregistered)

    WinEDA_NetlistFrame* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer2->Add(itemBoxSizer3, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer4 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer3->Add(itemBoxSizer4, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxString m_Select_By_TimestampStrings[] = {
        _("Reference"),
        _("Timestamp")
    };
    m_Select_By_Timestamp = new wxRadioBox( itemDialog1, ID_RADIOBOX, _("Module Selection:"), wxDefaultPosition, wxDefaultSize, 2, m_Select_By_TimestampStrings, 1, wxRA_SPECIFY_COLS );
    itemBoxSizer4->Add(m_Select_By_Timestamp, 0, wxGROW|wxALL, 5);

    wxString m_DeleteBadTracksStrings[] = {
        _("Keep"),
        _("Delete")
    };
    m_DeleteBadTracks = new wxRadioBox( itemDialog1, ID_RADIOBOX1, _("Bad Tracks Deletion:"), wxDefaultPosition, wxDefaultSize, 2, m_DeleteBadTracksStrings, 1, wxRA_SPECIFY_COLS );
    itemBoxSizer4->Add(m_DeleteBadTracks, 0, wxGROW|wxALL, 5);

    wxString m_ChangeExistantModuleCtrlStrings[] = {
        _("Keep"),
        _("Change")
    };
    m_ChangeExistantModuleCtrl = new wxRadioBox( itemDialog1, ID_RADIOBOX2, _("Exchange Module:"), wxDefaultPosition, wxDefaultSize, 2, m_ChangeExistantModuleCtrlStrings, 1, wxRA_SPECIFY_COLS );
    itemBoxSizer4->Add(m_ChangeExistantModuleCtrl, 0, wxGROW|wxALL, 5);

    m_DisplayWarningCtrl = new wxCheckBox( itemDialog1, ID_CHECKBOX, _("Display Warnings"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_DisplayWarningCtrl->SetValue(false);
    itemBoxSizer4->Add(m_DisplayWarningCtrl, 0, wxGROW|wxALL, 5);

    itemBoxSizer3->Add(5, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer10 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer3->Add(itemBoxSizer10, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton11 = new wxButton( itemDialog1, ID_OPEN_NELIST, _("Select"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton11->SetForegroundColour(wxColour(217, 0, 0));
    itemBoxSizer10->Add(itemButton11, 0, wxGROW|wxALL, 5);

    wxButton* itemButton12 = new wxButton( itemDialog1, ID_READ_NETLIST_FILE, _("Read"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton12->SetForegroundColour(wxColour(0, 128, 0));
    itemBoxSizer10->Add(itemButton12, 0, wxGROW|wxALL, 5);

    wxButton* itemButton13 = new wxButton( itemDialog1, ID_TEST_NETLIST, _("Module Test"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton13->SetForegroundColour(wxColour(0, 128, 128));
    itemBoxSizer10->Add(itemButton13, 0, wxGROW|wxALL, 5);

    wxButton* itemButton14 = new wxButton( itemDialog1, ID_COMPILE_RATSNEST, _("Compile"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton14->SetForegroundColour(wxColour(0, 0, 132));
    itemBoxSizer10->Add(itemButton14, 0, wxGROW|wxALL, 5);

    wxButton* itemButton15 = new wxButton( itemDialog1, wxID_CLOSE, _("&Close"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton15->SetForegroundColour(wxColour(128, 0, 128));
    itemBoxSizer10->Add(itemButton15, 0, wxGROW|wxALL, 5);

    m_MessageWindow = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T(""), wxDefaultPosition, wxSize(-1, 120), wxTE_MULTILINE|wxTE_READONLY );
    itemBoxSizer2->Add(m_MessageWindow, 0, wxGROW|wxALL, 5);

    // Set validators
    m_DisplayWarningCtrl->SetValidator( wxGenericValidator(& DisplayWarning) );
////@end WinEDA_NetlistFrame content construction
}

/*!
 * Should we show tooltips?
 */

bool WinEDA_NetlistFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_NetlistFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_NetlistFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_NetlistFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon WinEDA_NetlistFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_NetlistFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_NetlistFrame icon retrieval
}
/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_OPEN_NELIST
 */

void WinEDA_NetlistFrame::OnOpenNelistClick( wxCommandEvent& event )
{
	Set_NetlisteName(event);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_READ_NETLIST_FILE
 */

void WinEDA_NetlistFrame::OnReadNetlistFileClick( wxCommandEvent& event )
{
	ReadPcbNetlist(event);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_TEST_NETLIST
 */

void WinEDA_NetlistFrame::OnTestNetlistClick( wxCommandEvent& event )
{
    ModulesControle(event);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_COMPILE_RATSNEST
 */

void WinEDA_NetlistFrame::OnCompileRatsnestClick( wxCommandEvent& event )
{
	m_Parent->Compile_Ratsnest(m_DC, TRUE);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CLOSE
 */

void WinEDA_NetlistFrame::OnCloseClick( wxCommandEvent& event )
{
    Close();
}


