/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathJar
extends ClasspathLocation {
    protected File file;
    protected ZipFile zipFile;
    protected boolean closeZipFileAtEnd;
    protected Hashtable packageCache;

    public ClasspathJar(File file, boolean closeZipFileAtEnd, AccessRuleSet accessRuleSet, String destinationPath) {
        super(accessRuleSet, destinationPath);
        this.file = file;
        this.closeZipFileAtEnd = closeZipFileAtEnd;
    }

    /*
     * Loose catch block
     */
    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter problemReporter) {
        ArrayList<ClasspathJar> arrayList;
        BufferedReader reader;
        block18: {
            reader = null;
            this.initialize();
            ArrayList<ClasspathJar> result = new ArrayList<ClasspathJar>();
            ZipEntry manifest = this.zipFile.getEntry("META-INF/MANIFEST.MF");
            if (manifest != null) {
                reader = new BufferedReader(new InputStreamReader(this.zipFile.getInputStream(manifest)));
                ManifestAnalyzer analyzer = new ManifestAnalyzer();
                boolean success = analyzer.analyzeManifestContents(reader);
                List calledFileNames = analyzer.getCalledFileNames();
                if (problemReporter != null) {
                    if (!success || analyzer.getClasspathSectionsCount() == 1 && calledFileNames == null) {
                        problemReporter.invalidClasspathSection(this.getPath());
                    } else if (analyzer.getClasspathSectionsCount() > 1) {
                        problemReporter.multipleClasspathSections(this.getPath());
                    }
                }
                if (calledFileNames != null) {
                    Iterator calledFilesIterator = calledFileNames.iterator();
                    String directoryPath = this.getPath();
                    int lastSeparator = directoryPath.lastIndexOf(File.separatorChar);
                    directoryPath = directoryPath.substring(0, lastSeparator + 1);
                    while (calledFilesIterator.hasNext()) {
                        result.add(new ClasspathJar(new File(String.valueOf(directoryPath) + (String)calledFilesIterator.next()), this.closeZipFileAtEnd, this.accessRuleSet, this.destinationPath));
                    }
                }
            }
            arrayList = result;
            if (reader == null) break block18;
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return arrayList;
        catch (IOException iOException) {
            block19: {
                try {
                    if (reader == null) break block19;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName, false);
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            ClassFileReader reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
            if (reader != null) {
                return new NameEnvironmentAnswer(reader, this.fetchAccessRestriction(qualifiedBinaryFileName));
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public char[][][] findTypeNames(String qualifiedPackageName) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        ArrayList<char[][]> answers = new ArrayList<char[][]>();
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        block0: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (!qualifiedPackageName.equals(packageName)) continue block0;
                int indexOfDot = fileName.lastIndexOf(46);
                if (indexOfDot == -1) continue;
                String typeName = fileName.substring(last + 1, indexOfDot);
                char[] packageArray = packageName.toCharArray();
                answers.add(CharOperation.arrayConcat(CharOperation.splitOn('/', packageArray), typeName.toCharArray()));
            }
        }
        int size = answers.size();
        if (size != 0) {
            char[][][] result = new char[size][][];
            answers.toArray((T[])result);
            return null;
        }
        return null;
    }

    public void initialize() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
    }

    public boolean isPackage(String qualifiedPackageName) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(qualifiedPackageName);
        }
        this.packageCache = new Hashtable(41);
        this.packageCache.put(Util.EMPTY_STRING, Util.EMPTY_STRING);
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        block0: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (this.packageCache.containsKey(packageName)) continue block0;
                this.packageCache.put(packageName, packageName);
                last = packageName.lastIndexOf(47);
            }
        }
        return this.packageCache.containsKey(qualifiedPackageName);
    }

    public void reset() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {}
            this.zipFile = null;
        }
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            char[] rawName = this.file.getAbsolutePath().toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(rawName, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(rawName, 0, CharOperation.lastIndexOf('.', rawName));
        }
        return this.normalizedPath;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.file.getAbsolutePath();
        }
        return this.path;
    }

    public static class ManifestAnalyzer {
        private static final int START = 0;
        private static final int IN_CLASSPATH_HEADER = 1;
        private static final int PAST_CLASSPATH_HEADER = 2;
        private static final int SKIPPING_WHITESPACE = 3;
        private static final int READING_JAR = 4;
        private static final int CONTINUING = 5;
        private static final int SKIP_LINE = 6;
        private static final char[] CLASSPATH_HEADER_TOKEN = "Class-Path:".toCharArray();
        private int ClasspathSectionsCount;
        private ArrayList calledFilesNames;

        public boolean analyzeManifestContents(Reader reader) throws IOException {
            int state = 0;
            int substate = 0;
            StringBuffer currentJarToken = new StringBuffer();
            this.ClasspathSectionsCount = 0;
            this.calledFilesNames = null;
            while (true) {
                int currentChar = reader.read();
                switch (state) {
                    case 0: {
                        if (currentChar == -1) {
                            return true;
                        }
                        if (currentChar == CLASSPATH_HEADER_TOKEN[0]) {
                            state = 1;
                            substate = 1;
                            break;
                        }
                        state = 6;
                        break;
                    }
                    case 1: {
                        if (currentChar == -1) {
                            return true;
                        }
                        if (currentChar == 10) {
                            state = 0;
                            break;
                        }
                        if (currentChar != CLASSPATH_HEADER_TOKEN[substate++]) {
                            state = 6;
                            break;
                        }
                        if (substate != CLASSPATH_HEADER_TOKEN.length) break;
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (currentChar == 32) {
                            state = 3;
                            ++this.ClasspathSectionsCount;
                            break;
                        }
                        return false;
                    }
                    case 3: {
                        if (currentChar == -1) {
                            return true;
                        }
                        if (currentChar == 10) {
                            state = 5;
                            break;
                        }
                        if (currentChar == 32) break;
                        currentJarToken.append((char)currentChar);
                        state = 4;
                        break;
                    }
                    case 5: {
                        if (currentChar == -1) {
                            return true;
                        }
                        if (currentChar == 10) {
                            state = 0;
                            break;
                        }
                        if (currentChar == 32) {
                            state = 3;
                            break;
                        }
                        if (currentChar == CLASSPATH_HEADER_TOKEN[0]) {
                            state = 1;
                            substate = 1;
                            break;
                        }
                        if (this.calledFilesNames == null) {
                            return false;
                        }
                        state = 6;
                        break;
                    }
                    case 6: {
                        if (currentChar == -1) {
                            return true;
                        }
                        if (currentChar != 10) break;
                        state = 0;
                        break;
                    }
                    case 4: {
                        if (currentChar == -1) {
                            return false;
                        }
                        if (currentChar == 10) {
                            state = 5;
                        } else if (currentChar == 32) {
                            state = 3;
                        } else {
                            currentJarToken.append((char)currentChar);
                            break;
                        }
                        if (this.calledFilesNames == null) {
                            this.calledFilesNames = new ArrayList();
                        }
                        this.calledFilesNames.add(currentJarToken.toString());
                        currentJarToken.setLength(0);
                    }
                }
            }
        }

        public int getClasspathSectionsCount() {
            return this.ClasspathSectionsCount;
        }

        public List getCalledFileNames() {
            return this.calledFilesNames;
        }
    }
}

